/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.util.FilePathSetting;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.SendingMessage;

public class StandardFwHeaderDefinition
implements FwHeaderDefinition {
    private String formatFileDir = "format";
    private String formatFileName = "header";
    private Object resendFlagOffValue = 0;

    @Override
    public RequestMessage readFwHeaderFrom(ReceivedMessage message) {
        FwHeader header = new FwHeader();
        DataRecordFormatter bodyFormatter = message.getFormatter();
        message.setFormatter(this.getFormatter());
        DataRecord headerRecord = message.readRecord();
        if (headerRecord == null) {
            throw new MessagingException("there was no FW Header records.");
        }
        header.putAll(headerRecord);
        header.setResendFlagOffValue(this.resendFlagOffValue);
        message.getRecords().remove(headerRecord);
        message.setFormatter(bodyFormatter);
        return new RequestMessage(header, message);
    }

    @Override
    public void writeFwHeaderTo(SendingMessage message, FwHeader header) {
        ByteArrayOutputStream bodyStream = message.getBodyStream();
        byte[] bodyBytes = bodyStream.toByteArray();
        bodyStream.reset();
        try {
            this.getFormatter().setOutputStream((OutputStream)bodyStream).initialize().writeRecord((Map)header);
            bodyStream.write(bodyBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StandardFwHeaderDefinition setFormatFileDir(String dirName) {
        this.formatFileDir = dirName;
        return this;
    }

    public StandardFwHeaderDefinition setFormatFileName(String fileName) {
        this.formatFileName = fileName;
        return this;
    }

    public synchronized DataRecordFormatter getFormatter() {
        return this.getFormatter(FilePathSetting.getInstance(), FormatterFactory.getInstance());
    }

    public synchronized DataRecordFormatter getFormatter(FilePathSetting filePathSetting, FormatterFactory formatterFactory) {
        File formatFile = filePathSetting.getFileWithoutCreate(this.formatFileDir, this.formatFileName);
        DataRecordFormatter formatter = formatterFactory.createFormatter(formatFile);
        return formatter;
    }

    public StandardFwHeaderDefinition setResendFlagOffValue(Object value) {
        this.resendFlagOffValue = value;
        return this;
    }

    public Object getResendFlagOffValue() {
        return this.resendFlagOffValue;
    }
}

