/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.util.MapUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.ResponseMessage;

public class StructuredResponseMessage
extends ResponseMessage {
    @Published(tag={"architect"})
    public StructuredResponseMessage(RequestMessage message) {
        super(message);
    }

    @Override
    public StructuredResponseMessage setFormatter(DataRecordFormatter formatter) {
        if (formatter != null) {
            formatter.initialize();
        }
        super.setFormatter(formatter);
        return this;
    }

    @Override
    public byte[] getBodyBytes() {
        super.getBodyBytes();
        ByteArrayOutputStream bodyStream = super.getBodyStream();
        bodyStream.reset();
        DataRecordFormatter formatter = this.getFormatter().setOutputStream((OutputStream)bodyStream).initialize();
        try {
            for (DataRecord record : this.getRecords()) {
                String recordType = record.getRecordType();
                if (recordType == null) {
                    formatter.writeRecord((Map)record);
                    continue;
                }
                formatter.writeRecord(recordType, (Map)record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.getBodyBytes();
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(Map<String, ?> record) {
        this.addRecord((String)null, (Map)record);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(String recordType, Map<String, ?> record) {
        DataRecord dr = new DataRecord();
        dr.setRecordType(recordType);
        dr.putAll(record);
        this.getRecords().add(dr);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(Object recordObj) {
        this.addRecord(null, recordObj);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(String recordType, Object recordObj) {
        this.addRecord(recordType, (Map)MapUtil.createFlatMap(recordObj));
        return this;
    }
}

