/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nablarch.core.util.MapUtil;
import nablarch.core.util.annotation.Published;

@Published
public class SyncMessage {
    private final String requestId;
    private final Map<String, Object> headerRecord;
    private final List<Map<String, Object>> dataRecords;

    public SyncMessage(String requestId) {
        this.requestId = requestId;
        this.headerRecord = new TreeMap<String, Object>();
        this.dataRecords = new ArrayList<Map<String, Object>>();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, Object> getHeaderRecord() {
        return this.headerRecord;
    }

    public SyncMessage setHeaderRecord(Map<String, Object> headerRecord) {
        this.headerRecord.putAll(headerRecord);
        return this;
    }

    public Map<String, Object> getDataRecord() {
        return this.dataRecords.isEmpty() ? null : this.dataRecords.get(0);
    }

    public List<Map<String, Object>> getDataRecords() {
        return this.dataRecords;
    }

    public SyncMessage addDataRecord(Map<String, Object> dataRecord) {
        this.dataRecords.add(dataRecord);
        return this;
    }

    public SyncMessage addDataRecord(Object form) {
        Map<String, Object> data = MapUtil.createFlatMap(form);
        this.dataRecords.add(data);
        return this;
    }
}

