/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.util.Map;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.MessageSenderSettings;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.SyncMessage;

@Published(tag={"architect"})
public class SyncMessageConvertor {
    public SendingMessage convertOnSendSync(MessageSenderSettings settings, SyncMessage requestMessage) {
        FwHeader fwHeader = new FwHeader();
        fwHeader.setRequestId(settings.getSendingRequestId());
        if (settings.getRetryCount() > 0) {
            fwHeader.setResendFlag("0");
        }
        requestMessage.getHeaderRecord().putAll(fwHeader);
        return this.createSendingMessage(settings, requestMessage);
    }

    public SendingMessage convertOnRetry(MessageSenderSettings settings, SyncMessage requestMessage, SendingMessage timeoutMessage, int retryCount) {
        FwHeader fwHeader = new FwHeader();
        fwHeader.setRequestId(settings.getSendingRequestId());
        fwHeader.setResendFlag("1");
        requestMessage.getHeaderRecord().putAll(fwHeader);
        SendingMessage sendingMessage = this.createSendingMessage(settings, requestMessage);
        sendingMessage.setCorrelationId(timeoutMessage.getMessageId());
        return sendingMessage;
    }

    protected SendingMessage createSendingMessage(MessageSenderSettings settings, SyncMessage requestMessage) {
        SendingMessage message = new SendingMessage();
        message.setDestination(settings.getDestination());
        message.setReplyTo(settings.getReplyTo());
        ((SendingMessage)message.setFormatter(settings.getHeaderFormatter())).addRecord("header", requestMessage.getHeaderRecord());
        message.setFormatter(settings.getSendingDataFormatter());
        for (Map<String, Object> dataRecord : requestMessage.getDataRecords()) {
            message.addRecord("data", dataRecord);
        }
        return message;
    }

    public SyncMessage convertOnReceiveSync(MessageSenderSettings settings, SyncMessage requestMessage, SendingMessage sendingMessage, ReceivedMessage receivedMessage) {
        SyncMessage responseMessage = new SyncMessage(requestMessage.getRequestId());
        responseMessage.setHeaderRecord((Map<String, Object>)((ReceivedMessage)receivedMessage.setFormatter(settings.getHeaderFormatter())).readRecord()).getDataRecords().addAll(((ReceivedMessage)receivedMessage.setFormatter(settings.getReceivedDataFormatter())).readRecords());
        return responseMessage;
    }
}

