/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.action;

import nablarch.common.handler.TransactionManagementHandler;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.db.support.DbAccessSupport;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.TransactionEventCallback;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.ResponseMessage;

public abstract class MessagingAction
extends DbAccessSupport
implements Handler<RequestMessage, ResponseMessage>,
TransactionEventCallback<RequestMessage> {
    @Published
    public MessagingAction() {
    }

    @Published
    protected abstract ResponseMessage onReceive(RequestMessage var1, ExecutionContext var2);

    @Published
    protected ResponseMessage onError(Throwable e, RequestMessage request, ExecutionContext context) {
        return null;
    }

    protected boolean usesAutoRead() {
        return true;
    }

    public ResponseMessage handle(RequestMessage req, ExecutionContext ctx) {
        if (this.usesAutoRead()) {
            req.readRecord();
            if (req.readRecord() != null) {
                throw new InvalidDataFormatException("There remains unread bytes after a record has read. if multi-record messages are allowed, you must unset 'autoRead' option of MessageAction.'");
            }
        }
        return this.onReceive(req, ctx);
    }

    public Class<TransactionManagementHandler> transactionCallBackWatchType() {
        return TransactionManagementHandler.class;
    }

    public void transactionAbnormalEnd(Throwable e, RequestMessage data, ExecutionContext ctx) {
        ResponseMessage errorResponse = this.onError(e, data, ctx);
        if (errorResponse != null) {
            errorResponse.throwAsError(e);
        }
    }

    public void transactionNormalEnd(RequestMessage data, ExecutionContext ctx) {
    }
}

