/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.handler;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;
import nablarch.fw.messaging.ErrorResponseMessage;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.MessageReadError;
import nablarch.fw.messaging.MessagingContext;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.ResponseMessage;
import nablarch.fw.messaging.StandardFwHeaderDefinition;
import nablarch.fw.results.InternalError;

public class MessageReplyHandler
implements Handler<Object, Result> {
    private FwHeaderDefinition fwHeaderDefinition = new StandardFwHeaderDefinition();
    private static final Logger LOGGER = LoggerManager.get(MessageReplyHandler.class);

    @Published(tag={"architect"})
    public MessageReplyHandler() {
    }

    public Result handle(Object data, ExecutionContext ctx) {
        Result result = null;
        Throwable error = null;
        try {
            result = (Result)ctx.handleNext(data);
            if (result instanceof DataReader.NoMoreRecord) {
                return result;
            }
        }
        catch (Throwable e) {
            error = e;
            try {
                result = this.errorResponseOf(e, ctx);
            }
            catch (Throwable th) {
                LOGGER.logWarn("an error occurred while replying error response. ", th, new Object[0]);
                this.rethrow(e);
            }
        }
        try {
            ResponseMessage res = (ResponseMessage)result;
            res.setFwHeaderDefinition(this.fwHeaderDefinition);
            if (res.getFwHeader().getStatusCode() == null) {
                res.getFwHeader().setStatusCode(this.getStatusCode(res));
            }
            MessagingContext.getInstance().send(res);
        }
        catch (Throwable th) {
            if (error != null) {
                LOGGER.logWarn("an error occurred while sending response. ", th, new Object[0]);
                this.rethrow(error);
            }
            this.rethrow(th);
        }
        if (error != null) {
            this.rethrow(error);
        }
        return result;
    }

    @Published(tag={"architect"})
    protected ResponseMessage errorResponseOf(Throwable e, ExecutionContext ctx) {
        if (e instanceof ErrorResponseMessage) {
            return ((ErrorResponseMessage)((Object)e)).getResponse();
        }
        RequestMessage req = (RequestMessage)ctx.getLastReadData();
        if (req == null) {
            if (e instanceof MessageReadError) {
                ReceivedMessage message = ((MessageReadError)((Object)e)).getReceivedMessage();
                req = new RequestMessage(new FwHeader(), message);
            } else {
                throw new MessagingException("An unexpected error occurred and could not respond any message to client.", e);
            }
        }
        ResponseMessage res = req.reply();
        Result result = e instanceof Result ? (Result)e : new InternalError(e);
        res.setStatusCodeHeader(Integer.toString(result.getStatusCode()));
        return res.setResult(result);
    }

    protected String getStatusCode(ResponseMessage message) {
        return Integer.toString(message.getStatusCode());
    }

    private void rethrow(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public MessageReplyHandler setFwHeaderDefinition(FwHeaderDefinition def) {
        this.fwHeaderDefinition = def;
        return this;
    }
}

