/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.handler;

import java.util.HashMap;
import java.util.Map;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.ResultSetIterator;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.db.statement.exception.DuplicateStatementException;
import nablarch.core.util.Builder;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.ResponseMessage;
import nablarch.fw.messaging.StandardFwHeaderDefinition;
import nablarch.fw.messaging.tableschema.SentMessageTableSchema;

public class MessageResendHandler
implements Handler<RequestMessage, ResponseMessage> {
    private SentMessageTableSchema schema = null;
    private String findAlreadySentMessageQuery = null;
    private String insertNewSentMessageDml = null;
    private FwHeaderDefinition fwHeaderDefinition = new StandardFwHeaderDefinition();

    public MessageResendHandler() {
        this.schema = new SentMessageTableSchema();
    }

    public synchronized void initialize() {
        if (this.findAlreadySentMessageQuery != null) {
            return;
        }
        this.findAlreadySentMessageQuery = Builder.join((Object[])new String[]{"SELECT", this.schema.getReplyQueueColumnName(), "AS replyQueue", ",", this.schema.getMessageIdColumnName(), "AS messageId", ",", this.schema.getBodyDataColumnName(), "AS bodyData", ",", this.schema.getRequestIdColumnName(), "AS requestId", ",", this.schema.getStatusCodeColumnName(), "AS statusCode", "FROM", this.schema.getTableName(), "WHERE", this.schema.getMessageIdColumnName(), "= ?", "AND", this.schema.getRequestIdColumnName(), "= ?"}, (String)" ");
        if (this.insertNewSentMessageDml != null) {
            return;
        }
        this.insertNewSentMessageDml = Builder.join((Object[])new String[]{"INSERT INTO", this.schema.getTableName(), "(", this.schema.getMessageIdColumnName(), ",", this.schema.getRequestIdColumnName(), ",", this.schema.getReplyQueueColumnName(), ",", this.schema.getStatusCodeColumnName(), ",", this.schema.getBodyDataColumnName(), ") VALUES ( ?, ?, ?, ?, ? )"}, (String)" ");
    }

    public ResponseMessage handle(RequestMessage request, ExecutionContext context) {
        if (this.findAlreadySentMessageQuery == null) {
            this.initialize();
        }
        if (!request.getFwHeader().isResendingSupported()) {
            return (ResponseMessage)context.handleNext((Object)request);
        }
        ResponseMessage reply = this.getAlreadySentReply(request);
        if (reply != null) {
            reply.setCorrelationId(request.getMessageId());
            return reply;
        }
        reply = (ResponseMessage)context.handleNext((Object)request);
        try {
            this.saveReply(request, reply);
            return reply;
        }
        catch (DuplicateStatementException e) {
            ResponseMessage alreadySent = this.getAlreadySentReply(request);
            if (alreadySent != null) {
                alreadySent.setCorrelationId(request.getMessageId());
                alreadySent.throwAsError();
            }
            throw e;
        }
    }

    public void saveReply(RequestMessage request, ResponseMessage response) {
        FwHeader fwHeader = request.getFwHeader();
        String messageId = fwHeader.isResendingRequest() ? request.getCorrelationId() : request.getMessageId();
        response.setFwHeaderDefinition(this.fwHeaderDefinition);
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("messageId", messageId);
        record.put("requestId", fwHeader.getRequestId());
        record.put("replyQueue", response.getDestination());
        record.put("statusCode", response.getStatusCode());
        record.put("bodyData", response.getBodyBytes());
        this.insertNewSentMessage(record);
    }

    public void insertNewSentMessage(Map<String, Object> values) {
        SqlPStatement stmt = DbConnectionContext.getConnection().prepareStatement(this.insertNewSentMessageDml);
        stmt.setString(1, values.get("messageId").toString());
        stmt.setString(2, values.get("requestId").toString());
        stmt.setString(3, values.get("replyQueue").toString());
        stmt.setString(4, values.get("statusCode").toString());
        stmt.setBytes(5, (byte[])values.get("bodyData"));
        stmt.execute();
    }

    public ResponseMessage getAlreadySentReply(RequestMessage request) {
        SqlRow record;
        String correlationId = request.getCorrelationId();
        if (correlationId == null) {
            correlationId = request.getMessageId();
        }
        return (record = this.findAlreadySentMessage(correlationId, request.getRequestPath())) != null ? new ResentResponse(record, request) : null;
    }

    public SqlRow findAlreadySentMessage(String messageId, String requestId) {
        SqlPStatement stmt = DbConnectionContext.getConnection().prepareStatement(this.findAlreadySentMessageQuery);
        stmt.setString(1, messageId);
        stmt.setString(2, requestId);
        ResultSetIterator results = stmt.executeQuery();
        if (!results.next()) {
            return null;
        }
        return results.getRow();
    }

    public MessageResendHandler setSentMessageTableSchema(SentMessageTableSchema schema) {
        this.schema = schema;
        return this;
    }

    public MessageResendHandler setFwHeaderDefinition(FwHeaderDefinition def) {
        this.fwHeaderDefinition = def;
        return this;
    }

    private static class ResentResponse
    extends ResponseMessage {
        private byte[] body;
        private final SqlRow record;

        public ResentResponse(SqlRow record, RequestMessage request) {
            super(request);
            this.setDestination(record.getString("replyQueue"));
            this.record = record;
            this.getFwHeader().setStatusCode(record.getString("statusCode").trim());
            this.body = record.getBytes("bodyData");
        }

        @Override
        public byte[] getBodyBytes() {
            return this.body;
        }
    }
}

