/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.logging;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FixedLengthDataRecordFormatter;
import nablarch.core.log.LogItem;
import nablarch.core.log.LogUtil;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.InterSystemMessage;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;

@Published(tag={"architect"})
public class MessagingLogFormatter {
    public static final String PROPS_PREFIX = "messagingLogFormatter.";
    private static final String PROPS_MASKING_CHAR = "messagingLogFormatter.maskingChar";
    private static final String PROPS_MASKING_PATTERNS = "messagingLogFormatter.maskingPatterns";
    private static final String DEFAULT_MASKING_CHAR = "*";
    private static final Pattern[] DEFAULT_MASKING_PATTERNS = new Pattern[0];
    private static final Pattern MULTIVALUE_SEPARATOR_PATTERN = Pattern.compile(",");
    private Map<String, String> props = AppLogUtil.getProps();
    private Map<String, LogItem<MessagingLogContext>> logItems = this.getLogItems();
    private final LogItem<MessagingLogContext>[] sentMessageLogItems = this.getFormattedLogItems(this.logItems, this.props, "messagingLogFormatter.sentMessageFormat", "@@@@ SENT MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\treply_to       = [$replyTo$]\n\ttime_to_live   = [$timeToLive$]\n\tmessage_body   = [$messageBody$]");
    private static final String PROPS_SENT_MESSAGE_FORMAT = "messagingLogFormatter.sentMessageFormat";
    private static final String DEFAULT_SENT_MESSAGE_FORMAT = "@@@@ SENT MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\treply_to       = [$replyTo$]\n\ttime_to_live   = [$timeToLive$]\n\tmessage_body   = [$messageBody$]";
    private final LogItem<MessagingLogContext>[] receivedMessageLogItems = this.getFormattedLogItems(this.logItems, this.props, "messagingLogFormatter.receivedMessageFormat", "@@@@ RECEIVED MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\treply_to       = [$replyTo$]\n\tmessage_body   = [$messageBody$]");
    private static final String PROPS_RECEIVED_MESSAGE_FORMAT = "messagingLogFormatter.receivedMessageFormat";
    private static final String DEFAULT_RECEIVED_MESSAGE_FORMAT = "@@@@ RECEIVED MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\treply_to       = [$replyTo$]\n\tmessage_body   = [$messageBody$]";
    private final LogItem<MessagingLogContext>[] httpSentMessageLogItems = this.getFormattedLogItems(this.logItems, this.props, "messagingLogFormatter.httpSentMessageFormat", "@@@@ HTTP SENT MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\tmessage_header = [$messageHeader$]\n\tmessage_body   = [$messageBody$]");
    private static final String PROPS_HTTP_SENT_MESSAGE_FORMAT = "messagingLogFormatter.httpSentMessageFormat";
    private static final String DEFAULT_HTTP_SENT_MESSAGE_FORMAT = "@@@@ HTTP SENT MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\tmessage_header = [$messageHeader$]\n\tmessage_body   = [$messageBody$]";
    private final LogItem<MessagingLogContext>[] httpReceivedMessageLogItems = this.getFormattedLogItems(this.logItems, this.props, "messagingLogFormatter.httpReceivedMessageFormat", "@@@@ HTTP RECEIVED MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\tmessage_header = [$messageHeader$]\n\tmessage_body   = [$messageBody$]");
    private static final String PROPS_HTTP_RECEIVED_MESSAGE_FORMAT = "messagingLogFormatter.httpReceivedMessageFormat";
    private static final String DEFAULT_HTTP_RECEIVED_MESSAGE_FORMAT = "@@@@ HTTP RECEIVED MESSAGE @@@@\n\tthread_name    = [$threadName$]\n\tmessage_id     = [$messageId$]\n\tdestination    = [$destination$]\n\tcorrelation_id = [$correlationId$]\n\tmessage_header = [$messageHeader$]\n\tmessage_body   = [$messageBody$]";

    public String getSentMessageLog(SendingMessage message) {
        return LogUtil.formatMessage(this.sentMessageLogItems, (Object)new MessagingLogContext(message));
    }

    public String getReceivedMessageLog(ReceivedMessage message) {
        return LogUtil.formatMessage(this.receivedMessageLogItems, (Object)new MessagingLogContext(message));
    }

    public String getHttpSentMessageLog(SendingMessage message, Charset charset) {
        return LogUtil.formatMessage(this.httpSentMessageLogItems, (Object)new MessagingLogContext(message, charset));
    }

    public String getHttpReceivedMessageLog(ReceivedMessage message, Charset charset) {
        return LogUtil.formatMessage(this.httpReceivedMessageLogItems, (Object)new MessagingLogContext(message, charset));
    }

    protected LogItem<MessagingLogContext>[] getFormattedLogItems(Map<String, LogItem<MessagingLogContext>> logItems, Map<String, String> props, String formatPropName, String defaultFormat) {
        String format = defaultFormat;
        if (props.containsKey(formatPropName)) {
            format = props.get(formatPropName);
        }
        return LogUtil.createFormattedLogItems(logItems, (String)format);
    }

    protected Map<String, LogItem<MessagingLogContext>> getLogItems() {
        HashMap<String, LogItem<MessagingLogContext>> logItems = new HashMap<String, LogItem<MessagingLogContext>>();
        logItems.put("$threadName$", new ThreadName());
        logItems.put("$messageId$", new MessageId());
        logItems.put("$destination$", new Destination());
        logItems.put("$correlationId$", new CorrelationId());
        logItems.put("$replyTo$", new ReplyTo());
        logItems.put("$timeToLive$", new TimeToLive());
        char maskingChar = this.getMaskingChar(this.props);
        Pattern[] bodyMaskingPatterns = this.getBodyMaskingPatterns(this.props);
        logItems.put("$messageBody$", new MessageBody(maskingChar, bodyMaskingPatterns));
        logItems.put("$messageBodyHex$", new MessageBodyHex(maskingChar, bodyMaskingPatterns));
        logItems.put("$messageBodyLength$", new MessageBodyLength());
        logItems.put("$messageHeader$", new MessageHeader());
        return logItems;
    }

    private char getMaskingChar(Map<String, String> props) {
        String maskingChar = this.getProp(props, PROPS_MASKING_CHAR, DEFAULT_MASKING_CHAR);
        if (maskingChar.toCharArray().length != 1) {
            throw new IllegalArgumentException(String.format("maskingChar was not char type. maskingChar = [%s]", maskingChar));
        }
        return maskingChar.charAt(0);
    }

    private Pattern[] getBodyMaskingPatterns(Map<String, String> props) {
        String patterns = props.get(PROPS_MASKING_PATTERNS);
        if (patterns == null) {
            return DEFAULT_MASKING_PATTERNS;
        }
        String[] splitPatterns = MULTIVALUE_SEPARATOR_PATTERN.split(patterns);
        ArrayList<Pattern> maskingPatterns = new ArrayList<Pattern>();
        for (String regex : splitPatterns) {
            if (StringUtil.isNullOrEmpty((String)(regex = regex.trim()))) continue;
            maskingPatterns.add(Pattern.compile(regex, 2));
        }
        return maskingPatterns.toArray(new Pattern[maskingPatterns.size()]);
    }

    private String getProp(Map<String, String> props, String propName, String defaultValue) {
        String value = props.get(propName);
        return value != null ? value : defaultValue;
    }

    public static class MessageHeader
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return ctx.getMessage().getHeaderMap().toString();
        }
    }

    public static class MessageBodyHex
    extends MessageBody {
        public MessageBodyHex(char maskingChar, Pattern[] maskingPatterns) {
            super(maskingChar, maskingPatterns);
        }

        @Override
        public String get(MessagingLogContext ctx) {
            String bodyString = super.get(ctx);
            if (StringUtil.isNullOrEmpty((String)bodyString)) {
                return "";
            }
            Charset charset = this.getCharset(ctx.getMessage());
            byte[] bodyBytes = bodyString.getBytes(charset);
            return new BigInteger(bodyBytes).toString(16).toUpperCase();
        }
    }

    public static class MessageBody
    implements LogItem<MessagingLogContext> {
        private char maskingChar;
        private Pattern[] maskingPatterns;

        public MessageBody(char maskingChar, Pattern[] maskingPatterns) {
            this.maskingPatterns = maskingPatterns;
            this.maskingChar = maskingChar;
        }

        public String get(MessagingLogContext ctx) {
            InterSystemMessage<?> message = ctx.getMessage();
            Charset charset = ctx.getCharset();
            if (charset == null) {
                charset = this.getCharset(message);
            }
            byte[] bodyBytes = message.getBodyBytes();
            return this.maskBodyText(new String(bodyBytes, charset));
        }

        protected Charset getCharset(InterSystemMessage<?> message) {
            DataRecordFormatter formatter = message.getFormatter();
            String encoding = "iso-8859-1";
            if (formatter instanceof FixedLengthDataRecordFormatter) {
                formatter.initialize();
                encoding = ((FixedLengthDataRecordFormatter)formatter).getDefaultEncoding().name();
            }
            return Charset.forName(encoding);
        }

        private String maskBodyText(String bodyText) {
            for (Pattern p : this.maskingPatterns) {
                StringBuilder sb = new StringBuilder();
                Matcher m = p.matcher(bodyText);
                int lastEnd = 0;
                while (m.find(lastEnd)) {
                    int start = m.start(1);
                    int end = m.end(1);
                    sb.append(bodyText.substring(lastEnd, start));
                    sb.append(StringUtil.repeat((Object)Character.valueOf(this.maskingChar), (int)(end - start)));
                    lastEnd = end;
                }
                sb.append(bodyText.substring(lastEnd));
                bodyText = sb.toString();
            }
            return bodyText;
        }
    }

    public static class MessageBodyLength
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return Integer.toString(ctx.getMessage().getBodyBytes().length);
        }
    }

    public static class TimeToLive
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            if (!(ctx.getMessage() instanceof SendingMessage)) {
                return "-";
            }
            SendingMessage message = (SendingMessage)ctx.getMessage();
            return Long.toString(message.getTimeToLive());
        }
    }

    public static class ReplyTo
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return ctx.getMessage().getReplyTo();
        }
    }

    public static class CorrelationId
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return ctx.getMessage().getCorrelationId();
        }
    }

    public static class Destination
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return ctx.getMessage().getDestination();
        }
    }

    public static class MessageId
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return ctx.getMessage().getMessageId();
        }
    }

    public static class ThreadName
    implements LogItem<MessagingLogContext> {
        public String get(MessagingLogContext ctx) {
            return Thread.currentThread().getName();
        }
    }

    public static class MessagingLogContext {
        private final InterSystemMessage<?> message;
        private final Charset charset;

        public MessagingLogContext(InterSystemMessage<?> message) {
            this.message = message;
            this.charset = null;
        }

        public MessagingLogContext(InterSystemMessage<?> message, Charset charset) {
            this.message = message;
            this.charset = charset;
        }

        public InterSystemMessage<?> getMessage() {
            return this.message;
        }

        public Charset getCharset() {
            return this.charset;
        }
    }
}

