/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.logging;

import java.nio.charset.Charset;
import java.util.Map;
import nablarch.core.log.LogUtil;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.ObjectUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.logging.MessagingLogFormatter;

public final class MessagingLogUtil {
    private static final String PROPS_CLASS_NAME = "messagingLogFormatter.className";
    private static final LogUtil.ObjectCreator<MessagingLogFormatter> MESSAGING_LOG_FORMATTER_CREATOR = new LogUtil.ObjectCreator<MessagingLogFormatter>(){

        public MessagingLogFormatter create() {
            MessagingLogFormatter formatter = null;
            Map props = AppLogUtil.getProps();
            if (props.containsKey(MessagingLogUtil.PROPS_CLASS_NAME)) {
                String className = (String)props.get(MessagingLogUtil.PROPS_CLASS_NAME);
                formatter = (MessagingLogFormatter)ObjectUtil.createInstance((String)className);
            } else {
                formatter = new MessagingLogFormatter();
            }
            return formatter;
        }
    };

    private MessagingLogUtil() {
    }

    public static void initialize() {
        MessagingLogUtil.getLogWriter();
    }

    private static MessagingLogFormatter getLogWriter() {
        return (MessagingLogFormatter)LogUtil.getObjectBoundToClassLoader(MESSAGING_LOG_FORMATTER_CREATOR);
    }

    @Published(tag={"architect"})
    public static String getSentMessageLog(SendingMessage message) {
        return MessagingLogUtil.getLogWriter().getSentMessageLog(message);
    }

    @Published(tag={"architect"})
    public static String getReceivedMessageLog(ReceivedMessage message) {
        return MessagingLogUtil.getLogWriter().getReceivedMessageLog(message);
    }

    @Published(tag={"architect"})
    public static String getHttpSentMessageLog(SendingMessage message, Charset charset) {
        return MessagingLogUtil.getLogWriter().getHttpSentMessageLog(message, charset);
    }

    @Published(tag={"architect"})
    public static String getHttpReceivedMessageLog(ReceivedMessage message, Charset charset) {
        return MessagingLogUtil.getLogWriter().getHttpReceivedMessageLog(message, charset);
    }
}

