/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.reader;

import java.io.File;
import nablarch.core.ThreadContext;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.StringUtil;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.MessageReadError;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.StandardFwHeaderDefinition;

public class FwHeaderReader
implements DataReader<RequestMessage> {
    private DataReader<ReceivedMessage> messageReader = null;
    private FwHeaderDefinition fwHeaderDef = new StandardFwHeaderDefinition();
    private String formatFileDir = "format";
    private String messageFormatFileNamePattern = "%s_RECEIVE";
    private String replyMessageFormatFileNamePattern = "%s_SEND";

    public RequestMessage read(ExecutionContext ctx) {
        ReceivedMessage message = (ReceivedMessage)this.messageReader.read(ctx);
        if (message == null) {
            return null;
        }
        RequestMessage req = null;
        try {
            req = this.fwHeaderDef.readFwHeaderFrom(message);
            FwHeader header = req.getFwHeader();
            ThreadContext.setRequestId((String)header.getRequestId());
            ThreadContext.setInternalRequestId((String)header.getRequestId());
            if (header.hasUserId()) {
                ThreadContext.setUserId((String)header.getUserId());
            }
            this.prepareMessageFormatter(req);
            this.prepareMessageFormatterOfReply(req);
            return req;
        }
        catch (RuntimeException e) {
            throw new MessageReadError(message, e);
        }
        catch (Error e) {
            throw new MessageReadError(message, e);
        }
    }

    public boolean hasNext(ExecutionContext ctx) {
        return this.messageReader.hasNext(ctx);
    }

    public void close(ExecutionContext ctx) {
        this.messageReader.close(ctx);
    }

    private void prepareMessageFormatter(RequestMessage req) {
        String requestId = req.getRequestPath();
        String fileName = String.format(this.messageFormatFileNamePattern, requestId);
        DataRecordFormatter formatter = this.formatterAt(this.formatFileDir, fileName);
        if (formatter != null) {
            req.setFormatter(formatter);
        }
    }

    private void prepareMessageFormatterOfReply(RequestMessage req) {
        String requestId = req.getRequestPath();
        String fileName = String.format(this.replyMessageFormatFileNamePattern, requestId);
        DataRecordFormatter formatter = this.formatterAt(this.formatFileDir, fileName);
        if (formatter != null) {
            req.setFormatterOfReply(formatter);
        }
    }

    private DataRecordFormatter formatterAt(String dirName, String fileName) {
        File file = FilePathSetting.getInstance().getFileIfExists(dirName, fileName);
        if (file == null) {
            return null;
        }
        return FormatterFactory.getInstance().createFormatter(file);
    }

    public FwHeaderReader setMessageReader(DataReader<ReceivedMessage> messageReader) {
        if (messageReader == null) {
            throw new IllegalArgumentException("messageReader must not be null.");
        }
        this.messageReader = messageReader;
        return this;
    }

    public FwHeaderReader setFwHeaderDefinition(FwHeaderDefinition def) {
        if (def == null) {
            throw new IllegalArgumentException("fwHeaderDefinition must not be null.");
        }
        this.fwHeaderDef = def;
        return this;
    }

    public FwHeaderReader setFormatFileDir(String dirName) {
        if (StringUtil.isNullOrEmpty((String)dirName)) {
            throw new IllegalArgumentException("'formatFileDir' must not be blank.");
        }
        this.formatFileDir = dirName;
        return this;
    }

    public FwHeaderReader setMessageFormatFileNamePattern(String pattern) {
        if (StringUtil.isNullOrEmpty((String)pattern)) {
            throw new IllegalArgumentException("'formatFileNamePattern' must not be blank.");
        }
        this.messageFormatFileNamePattern = pattern;
        return this;
    }

    public FwHeaderReader setReplyMessageFormatFileNamePattern(String pattern) {
        if (StringUtil.isNullOrEmpty((String)pattern)) {
            throw new IllegalArgumentException("'formatFileNamePattern' must not be blank.");
        }
        this.replyMessageFormatFileNamePattern = pattern;
        return this;
    }
}

