/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.reader;

import java.io.File;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.util.FilePathSetting;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.messaging.MessageReadError;
import nablarch.fw.messaging.MessagingContext;
import nablarch.fw.messaging.ReceivedMessage;

public class MessageReader
implements DataReader<ReceivedMessage> {
    private String receiveQueueName;
    private boolean closed = false;
    private long timeout = 5000L;
    private String formatFileDirName = "format";
    private String formatFileName = null;

    public ReceivedMessage read(ExecutionContext ctx) {
        if (this.closed) {
            return null;
        }
        if (this.receiveQueueName == null) {
            throw new IllegalStateException("the name of the queue this reader watches must be assigned.");
        }
        ReceivedMessage message = null;
        try {
            message = MessagingContext.getInstance().receiveSync(this.receiveQueueName, this.timeout);
            if (message == null) {
                return null;
            }
            if (this.formatFileName != null) {
                message.setFormatter(this.getFormatter());
            }
            return message;
        }
        catch (RuntimeException e) {
            if (message == null) {
                throw e;
            }
            throw new MessageReadError(message, e);
        }
        catch (Error e) {
            if (message == null) {
                throw e;
            }
            throw new MessageReadError(message, e);
        }
    }

    public boolean hasNext(ExecutionContext ctx) {
        return !this.closed;
    }

    public void close(ExecutionContext ctx) {
        this.closed = true;
    }

    private DataRecordFormatter getFormatter() {
        File formatFile = FilePathSetting.getInstance().getFileWithoutCreate(this.formatFileDirName, this.formatFileName);
        DataRecordFormatter formatter = FormatterFactory.getInstance().createFormatter(formatFile);
        return formatter;
    }

    public MessageReader setReceiveQueueName(String queueName) {
        this.receiveQueueName = queueName;
        return this;
    }

    public MessageReader setReadTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public MessageReader setFormatFileName(String fileName) {
        this.formatFileName = fileName;
        return this;
    }

    public MessageReader setFormatFileDirName(String dirName) {
        this.formatFileDirName = dirName;
        return this;
    }
}

