/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.reader;

import java.io.File;
import java.util.Map;
import nablarch.core.ThreadContext;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.util.FilePathSetting;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.StructuredRequestMessage;

public class StructuredFwHeaderDefinition
implements FwHeaderDefinition {
    private String resendFlagOffValue = "0";
    private String formatFileDir = "format";
    private String headerFormatFileNamePattern = "%s_RECEIVE";
    private Map<String, String> fwHeaderKeys = null;

    @Override
    public RequestMessage readFwHeaderFrom(ReceivedMessage message) {
        FwHeader fwHeader = new FwHeader();
        String requestId = ThreadContext.getRequestId();
        fwHeader.setRequestId(requestId);
        fwHeader.setResendFlagOffValue(this.getResendFlagOffValue());
        message.setFormatter(this.getFormatter(requestId));
        DataRecord headerRecord = message.readRecord();
        if (headerRecord == null) {
            throw new MessagingException("there was no FW Header records.");
        }
        if (this.fwHeaderKeys != null) {
            for (Map.Entry<String, String> e : this.fwHeaderKeys.entrySet()) {
                String key = e.getValue();
                if (!headerRecord.containsKey((Object)key)) continue;
                fwHeader.put(e.getKey(), headerRecord.get((Object)key));
            }
        }
        ReceivedMessage receivedMessage = new ReceivedMessage(message.getBodyBytes());
        receivedMessage.setHeaderMap(message.getHeaderMap());
        receivedMessage.setFormatter(message.getFormatter());
        receivedMessage.getRecords().addAll(message.getRecords());
        return new StructuredRequestMessage(fwHeader, receivedMessage);
    }

    public synchronized DataRecordFormatter getFormatter(String dataType) {
        return this.getFormatter(dataType, FilePathSetting.getInstance(), FormatterFactory.getInstance());
    }

    public synchronized DataRecordFormatter getFormatter(String dataType, FilePathSetting filePathSetting, FormatterFactory formatterFactory) {
        String formatFileName = String.format(this.headerFormatFileNamePattern, dataType);
        File formatFile = filePathSetting.getFileWithoutCreate(this.formatFileDir, formatFileName);
        DataRecordFormatter formatter = formatterFactory.createFormatter(formatFile);
        return formatter;
    }

    @Override
    public void writeFwHeaderTo(SendingMessage message, FwHeader header) {
        Map<String, Object> rec;
        if (this.fwHeaderKeys != null && (rec = message.getParamMap()) != null) {
            for (Map.Entry<String, String> e : this.fwHeaderKeys.entrySet()) {
                String key = e.getKey();
                if (!header.containsKey(key)) continue;
                rec.put(e.getValue(), header.get(key));
            }
        }
    }

    public StructuredFwHeaderDefinition setResendFlagOffValue(String value) {
        this.resendFlagOffValue = value;
        return this;
    }

    public String getResendFlagOffValue() {
        return this.resendFlagOffValue;
    }

    public StructuredFwHeaderDefinition setFwHeaderKeys(Map<String, String> fwHeaderKeys) {
        this.fwHeaderKeys = fwHeaderKeys;
        return this;
    }
}

