/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.common.handler.threadcontext.ExecutionIdAttribute;
import nablarch.common.handler.threadcontext.ThreadContextAttribute;
import nablarch.core.ThreadContext;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;

public class DataReadHandler
implements Handler<Object, Result> {
    private static final Logger LOGGER = LoggerManager.get(DataReadHandler.class);
    private int readCount = 0;
    private int maxCount = 0;
    private ThreadContextAttribute<Object> executionIdAttribute = new ExecutionIdAttribute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handle(Object o, ExecutionContext context) {
        boolean isNextRecord;
        if (this.maxCount > 0) {
            DataReadHandler dataReadHandler = this;
            synchronized (dataReadHandler) {
                this.countUp(context);
            }
        }
        if (!(isNextRecord = context.hasNextData())) {
            return new DataReader.NoMoreRecord();
        }
        Object requestData = context.readNextData();
        if (requestData == null) {
            return new DataReader.NoMoreRecord();
        }
        ThreadContext.setExecutionId((String)((String)this.executionIdAttribute.getValue(o, context)));
        try {
            context.setRequestScopedVar("nablarch_request-data", requestData);
            return (Result)context.handleNext(requestData);
        }
        catch (RuntimeException e) {
            this.writeWarnLog(requestData, e);
            throw e;
        }
        catch (Error e) {
            this.writeWarnLog(requestData, e);
            throw e;
        }
    }

    protected void writeWarnLog(Object requestData, Throwable t) {
        LOGGER.logWarn("application was abnormal end." + Logger.LS + '\t' + "input data = " + (requestData == null ? "null" : requestData.toString()), t, new Object[0]);
    }

    private void countUp(ExecutionContext context) {
        ++this.readCount;
        if (this.readCount > this.maxCount) {
            context.setDataReaderFactory(null);
            context.setDataReader(null);
        }
    }

    public DataReadHandler setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public DataReadHandler setExecutionIdAttribute(ExecutionIdAttribute attribute) {
        this.executionIdAttribute = attribute;
        return this;
    }
}

