/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.DataReaderFactory;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.handler.ExecutionHandlerCallback;

interface ExecutionHandler<TData, TResult, TSelf extends ExecutionHandler>
extends Handler<TData, TResult> {

    public static final class Support<TData, TResult> {
        private static final Logger LOGGER = LoggerManager.get(ExecutionHandler.class);

        public List<ExecutionHandlerCallback> prepareListeners(TData data, ExecutionContext ctx) {
            return ctx.selectHandlers(data, ExecutionHandlerCallback.class, ExecutionHandler.class);
        }

        public void callPreExecution(List<ExecutionHandlerCallback> listeners, TData data, ExecutionContext ctx) {
            for (ExecutionHandlerCallback listener : listeners) {
                listener.preExecution(data, ctx);
            }
        }

        public void callErrorInExecution(List<ExecutionHandlerCallback> listeners, Throwable e, ExecutionContext ctx) {
            for (ExecutionHandlerCallback listener : listeners) {
                try {
                    listener.errorInExecution(e, ctx);
                }
                catch (Throwable t) {
                    LOGGER.logWarn("An error occurred while processing an error callback.", t, new Object[0]);
                }
            }
        }

        public void callPostExecution(List<ExecutionHandlerCallback> listeners, TResult result, ExecutionContext ctx) {
            ArrayList<Throwable> raisedErrors = new ArrayList<Throwable>();
            for (ExecutionHandlerCallback listener : listeners) {
                try {
                    listener.postExecution(result, ctx);
                }
                catch (RuntimeException e) {
                    raisedErrors.add(e);
                    LOGGER.logWarn("An error occurred while processing an postExecution callback.", (Throwable)e, new Object[0]);
                }
                catch (Error e) {
                    raisedErrors.add(e);
                    LOGGER.logWarn("An error occurred while processing an postExecution callback.", (Throwable)e, new Object[0]);
                }
                if (raisedErrors.isEmpty()) continue;
                Throwable t = (Throwable)raisedErrors.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (Error)t;
            }
        }

        public void prepareDataReader(Object data, ExecutionContext context) {
            if (context.getDataReader() != null) {
                return;
            }
            DataReaderFactory readerFactory = (DataReaderFactory)context.findHandler(data, DataReaderFactory.class, ExecutionHandler.class);
            if (readerFactory == null) {
                throw new IllegalStateException("Any DataReader or DataReaderFactory is not available.");
            }
            context.setDataReaderFactory(readerFactory).getDataReader();
        }
    }
}

