/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.log.app.CommitLogger;
import nablarch.core.transaction.Transaction;
import nablarch.core.transaction.TransactionContext;
import nablarch.core.transaction.TransactionExecutor;
import nablarch.core.transaction.TransactionFactory;
import nablarch.core.util.StringUtil;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;
import nablarch.fw.TransactionEventCallback;

public class LoopHandler
extends TransactionEventCallback.Provider<Object>
implements Handler<Object, Result> {
    private CommitLogger commitLogger;
    private static final String IS_ABOUT_TO_COMMIT_FLAG_KEY = "nablarch_LoopHandler_is_about_to_commit";
    private TransactionFactory transactionFactory;
    private String transactionName = "transaction";
    private int commitInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result handle(Object data, ExecutionContext context) {
        this.commitLogger = (CommitLogger)context.getSessionScopedVar("nablarch_.commit-logger");
        Transaction transaction = this.transactionFactory.getTransaction(this.transactionName);
        TransactionContext.setTransaction((String)this.transactionName, (Transaction)transaction);
        List listeners = this.prepareListeners(data, context);
        try {
            new TransactionExecutorImpl(transaction, context, data, listeners).execute();
        }
        finally {
            TransactionContext.removeTransaction((String)this.transactionName);
        }
        return new Result.Success();
    }

    private long commit(Transaction transaction, long count, ExecutionContext context) {
        if (this.commitInterval <= 1 || count >= (long)this.commitInterval || !context.hasNextData() && count != 0L) {
            transaction.commit();
            if (this.commitLogger != null) {
                this.commitLogger.increment(count);
            }
            return 0L;
        }
        return count;
    }

    private void errorCallback(Transaction transaction, final Throwable e, final ExecutionContext context, final List<TransactionEventCallback> listeners) {
        final Object data = LoopHandler.getTransactionData(context);
        if (data == null) {
            return;
        }
        new TransactionExecutor<Void>(transaction){

            protected Void doInTransaction(Transaction transaction) {
                LoopHandler.this.callAbnormalEndHandlers(listeners, e, data, context);
                return null;
            }
        }.execute();
    }

    private static Object getTransactionData(ExecutionContext context) {
        return context.getRequestScopedVar("nablarch_request-data");
    }

    private ExecutionContext restoreHandlerQueue(ExecutionContext context, List<Handler> snapshot) {
        List queue = context.getHandlerQueue();
        queue.clear();
        queue.addAll(snapshot);
        return context;
    }

    public boolean shouldStop(ExecutionContext context) {
        return !context.hasNextData();
    }

    public LoopHandler setTransactionFactory(TransactionFactory transactionFactory) {
        assert (transactionFactory != null);
        this.transactionFactory = transactionFactory;
        return this;
    }

    public void setTransactionName(String transactionName) {
        assert (!StringUtil.isNullOrEmpty((String)transactionName));
        this.transactionName = transactionName;
    }

    public LoopHandler setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
        return this;
    }

    public static final boolean isAboutToCommit(ExecutionContext ctx) {
        Boolean isAboutToCommit = (Boolean)ctx.getRequestScopedVar(IS_ABOUT_TO_COMMIT_FLAG_KEY);
        if (isAboutToCommit == null) {
            isAboutToCommit = true;
        }
        return isAboutToCommit != false || !ctx.getDataReader().hasNext(ctx);
    }

    private final class TransactionExecutorImpl
    extends TransactionExecutor<Void> {
        private final ExecutionContext context;
        private final Object data;
        private final List<TransactionEventCallback> listeners;

        private TransactionExecutorImpl(Transaction transaction, ExecutionContext context, Object data, List<TransactionEventCallback> listeners) {
            super(transaction);
            this.context = context;
            this.data = data;
            this.listeners = listeners;
        }

        protected Void doInTransaction(Transaction transaction) {
            ArrayList snapshot = new ArrayList();
            snapshot.addAll(this.context.getHandlerQueue());
            long executeCount = 0L;
            this.context.setRequestScopedVar(LoopHandler.IS_ABOUT_TO_COMMIT_FLAG_KEY, (Object)false);
            do {
                this.context.setRequestScopedVar("nablarch_request-data", null);
                this.context.setRequestScopedVar(LoopHandler.IS_ABOUT_TO_COMMIT_FLAG_KEY, (Object)(LoopHandler.this.commitInterval <= 1 || executeCount == (long)(LoopHandler.this.commitInterval - 1) ? 1 : 0));
                Object result = LoopHandler.this.restoreHandlerQueue(this.context, snapshot).handleNext(this.data);
                if (!(result instanceof DataReader.NoMoreRecord)) {
                    Object transactionData = LoopHandler.getTransactionData(this.context);
                    if (transactionData != null) {
                        LoopHandler.this.callNormalEndHandlers(this.listeners, transactionData, this.context);
                    }
                    ++executeCount;
                }
                executeCount = LoopHandler.this.commit(transaction, executeCount, this.context);
                this.context.clearLastReadData();
            } while (!LoopHandler.this.shouldStop(this.context));
            LoopHandler.this.commit(transaction, executeCount, this.context);
            return null;
        }

        protected void onError(Transaction transaction, Throwable throwable) {
            super.onError(transaction, throwable);
            LoopHandler.this.errorCallback(transaction, throwable, this.context, this.listeners);
        }
    }
}

