/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.util.ObjectUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;
import nablarch.fw.handler.ProcessStopHandler;
import nablarch.fw.handler.retry.RetryUtil;
import nablarch.fw.handler.retry.RetryableException;
import nablarch.fw.launcher.ProcessAbnormalEnd;
import nablarch.fw.results.ServiceError;
import nablarch.fw.results.ServiceUnavailable;

public class ProcessResidentHandler
implements Handler<Object, Object> {
    private static final Logger LOGGER = LoggerManager.get(ProcessResidentHandler.class);
    private int dataWatchInterval = 1000;
    private final List<Class<? extends RuntimeException>> normalEndExceptions = new ArrayList<Class<? extends RuntimeException>>(){
        {
            this.add(ProcessStopHandler.ProcessStop.class);
        }
    };
    private final List<Class<? extends RuntimeException>> abnormalEndExceptions = new ArrayList<Class<? extends RuntimeException>>(){
        {
            this.add(ProcessAbnormalEnd.class);
        }
    };

    public Object handle(Object data, ExecutionContext context) {
        LOGGER.logInfo(String.format("DATA WATCH INTERVAL = [%dms]", this.dataWatchInterval), new Object[0]);
        ArrayList<Handler> snapshot = new ArrayList<Handler>();
        snapshot.addAll(context.getHandlerQueue());
        Object result = new Result.Success();
        while (true) {
            long executeTime = 0L;
            long start = System.currentTimeMillis();
            try {
                context.setDataReader(null);
                context.setDataReaderFactory(null);
                result = this.restoreHandlerQueue(context, snapshot).handleNext(data);
            }
            catch (ServiceUnavailable e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("this process is asleep because the service temporarily unavailable.", new Object[0]);
                }
            }
            catch (RuntimeException e) {
                if (RetryUtil.isRetryable(e)) {
                    throw e;
                }
                if (this.isProcessAbnormalEnd(e)) {
                    throw e;
                }
                if (this.isProcessNormalEnd(e)) {
                    LOGGER.logInfo("stop the resident process.", (Throwable)e, new Object[0]);
                    break;
                }
                if (e instanceof ServiceError) {
                    ((ServiceError)e).writeLog(context);
                } else {
                    FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                }
                throw new RetryableException(e);
            }
            executeTime = System.currentTimeMillis() - start;
            try {
                long currentSleepTime = (long)this.dataWatchInterval - executeTime;
                Thread.sleep(currentSleepTime <= 0L ? 1L : currentSleepTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean isProcessAbnormalEnd(RuntimeException runtimeException) {
        for (Class<? extends RuntimeException> exception : this.abnormalEndExceptions) {
            if (!exception.isAssignableFrom(runtimeException.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isProcessNormalEnd(RuntimeException runtimeException) {
        for (Class<? extends RuntimeException> exception : this.normalEndExceptions) {
            if (!exception.isAssignableFrom(runtimeException.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setDataWatchInterval(int dataWatchInterval) {
        if (dataWatchInterval <= 0) {
            throw new IllegalArgumentException("data watch interval time was invalid. please set a value greater than 1. specified value is:" + dataWatchInterval);
        }
        this.dataWatchInterval = dataWatchInterval;
    }

    public void setNormalEndExceptions(List<String> normalEndExceptions) {
        this.normalEndExceptions.clear();
        this.normalEndExceptions.addAll(ObjectUtil.createExceptionsClassList(normalEndExceptions));
    }

    public void setAbnormalEndExceptions(List<String> abnormalEndExceptions) {
        this.abnormalEndExceptions.clear();
        this.abnormalEndExceptions.addAll(ObjectUtil.createExceptionsClassList(abnormalEndExceptions));
    }

    private ExecutionContext restoreHandlerQueue(ExecutionContext context, List<Handler> snapshot) {
        List queue = context.getHandlerQueue();
        queue.clear();
        queue.addAll(snapshot);
        return context;
    }
}

