/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;
import nablarch.fw.handler.ProcessStopHandler;
import nablarch.fw.handler.retry.RetryUtil;
import nablarch.fw.handler.retry.RetryableException;
import nablarch.fw.launcher.ProcessAbnormalEnd;
import nablarch.fw.results.ServiceError;
import nablarch.fw.results.ServiceUnavailable;

public class RequestThreadLoopHandler
implements Handler<Object, Object> {
    private int serviceUnavailabilityRetryInterval = 1000;
    private static final Logger LOGGER = LoggerManager.get(RequestThreadLoopHandler.class);

    public Result handle(Object data, ExecutionContext ctx) {
        ServiceUnavailable result = null;
        while (ctx.hasNextData()) {
            try {
                ExecutionContext clonedCtx = ctx.copy();
                result = (Result)clonedCtx.handleNext(data);
            }
            catch (ServiceUnavailable e) {
                int interval;
                result = e;
                int n = interval = this.serviceUnavailabilityRetryInterval <= 0 ? 0 : this.serviceUnavailabilityRetryInterval;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("request thread waits " + interval + "msec due to temporary service unavailability.", new Object[0]);
                }
                if (interval <= 0) continue;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
            catch (ProcessStopHandler.ProcessStop e) {
                LOGGER.logInfo("the shutdown flag of this process was set. shutting down...", new Object[0]);
                return new Result.Success("shut down this process normally.");
            }
            catch (ProcessAbnormalEnd e) {
                throw e;
            }
            catch (ServiceError e) {
                e.writeLog(ctx);
                throw new RetryableException(e);
            }
            catch (Result.Error e) {
                FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                throw new RetryableException(e);
            }
            catch (RuntimeException e) {
                if (RetryUtil.isRetryable(e)) {
                    throw e;
                }
                FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                throw new RetryableException(e);
            }
            catch (ThreadDeath e) {
                LOGGER.logInfo("Uncaught error: ", (Throwable)e, new Object[0]);
                throw e;
            }
            catch (StackOverflowError e) {
                FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                throw new RetryableException(e);
            }
            catch (OutOfMemoryError e) {
                System.err.println("OutOfMemoryError occurred: " + e.getMessage());
                try {
                    FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                }
                catch (Throwable ignored) {
                    LOGGER.logDebug("couldn't write log. : ", (Throwable)e, new Object[0]);
                }
                throw new RetryableException(e);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Error e) {
                FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                throw new RetryableException(e);
            }
        }
        return result;
    }

    public RequestThreadLoopHandler setServiceUnavailabilityRetryInterval(int msec) {
        this.serviceUnavailabilityRetryInterval = msec;
        return this;
    }
}

