/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.ArrayList;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.handler.retry.RetryUtil;
import nablarch.fw.launcher.ProcessAbnormalEnd;

public class RetryHandler
implements Handler<Object, Object> {
    private static final Logger LOGGER = LoggerManager.get(RetryHandler.class);
    private RetryContextFactory retryContextFactory;
    private int retryLimitExceededExitCode = 180;
    private String retryLimitExceededFailureCode;
    private boolean destroyReader;

    public Object handle(Object data, ExecutionContext context) {
        ArrayList snapshot = new ArrayList();
        snapshot.addAll(context.getHandlerQueue());
        RetryContext retryContext = this.retryContextFactory.createRetryContext();
        while (true) {
            try {
                Object result = context.handleNext(data);
                retryContext.reset();
                return result;
            }
            catch (RuntimeException e) {
                if (!RetryUtil.isRetryable(e)) {
                    retryContext.reset();
                    throw e;
                }
                if (retryContext.isRetryable()) {
                    LOGGER.logWarn(String.format("caught a exception to retry. start retry. retryCount[%s]", retryContext.getCurrentRetryCount() + 1), (Throwable)e, new Object[0]);
                    retryContext.prepareRetry();
                    context.getHandlerQueue().clear();
                    context.getHandlerQueue().addAll(snapshot);
                    if (!this.destroyReader) continue;
                    RetryHandler.destroyDataReader(context);
                    continue;
                }
                LOGGER.logWarn(String.format("retry process failed. retry limit was exceeded.", new Object[0]), (Throwable)e, new Object[0]);
                retryContext.reset();
                throw new ProcessAbnormalEnd(this.retryLimitExceededExitCode, e, this.retryLimitExceededFailureCode, new Object[0]);
            }
            break;
        }
    }

    private static void destroyDataReader(ExecutionContext context) {
        context.setDataReader(null);
        context.setDataReaderFactory(null);
    }

    public void setDestroyReader(boolean destroyReader) {
        this.destroyReader = destroyReader;
    }

    public void setRetryContextFactory(RetryContextFactory retryContextFactory) {
        this.retryContextFactory = retryContextFactory;
    }

    public void setRetryLimitExceededExitCode(int retryLimitExceededExitCode) {
        this.retryLimitExceededExitCode = retryLimitExceededExitCode;
    }

    public void setRetryLimitExceededFailureCode(String retryLimitExceededFailureCode) {
        this.retryLimitExceededFailureCode = retryLimitExceededFailureCode;
    }

    @Published(tag={"architect"})
    public static interface RetryContextFactory {
        public RetryContext createRetryContext();
    }

    @Published(tag={"architect"})
    public static interface RetryContext {
        public int getCurrentRetryCount();

        public boolean isRetryable();

        public void prepareRetry();

        public void reset();
    }
}

