/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;

public class StatusCodeConvertHandler
implements Handler<Object, Integer> {
    public Integer handle(Object o, ExecutionContext context) {
        Result result = (Result)context.handleNext(o);
        return StatusCodeConvertHandler.convert(result.getStatusCode());
    }

    private static int convert(int statusCode) {
        if (statusCode < 0) {
            return 1;
        }
        if (statusCode >= 200 && statusCode <= 399) {
            return 0;
        }
        if (statusCode == 400) {
            return 10;
        }
        if (statusCode == 401) {
            return 11;
        }
        if (statusCode == 403) {
            return 12;
        }
        if (statusCode == 404) {
            return 13;
        }
        if (statusCode == 409) {
            return 14;
        }
        if (400 <= statusCode && statusCode <= 499) {
            return 15;
        }
        if (statusCode >= 500) {
            return 20;
        }
        return statusCode;
    }
}

