/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler.retry;

import nablarch.core.util.annotation.Published;
import nablarch.fw.handler.retry.RetryContextSupport;

@Published(tag={"architect"})
public class CountingRetryContext
extends RetryContextSupport {
    private final int retryCount;

    protected CountingRetryContext(int retryCount, long maxRetryTime, long retryIntervals) {
        super(maxRetryTime, retryIntervals);
        this.retryCount = retryCount;
        this.assertMaxRetryTime(maxRetryTime, (long)retryCount * retryIntervals);
    }

    @Override
    protected boolean onIsRetryable() {
        return this.getCurrentRetryCount() < this.retryCount;
    }
}

