/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler.retry;

import java.text.SimpleDateFormat;
import java.util.Date;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.handler.RetryHandler;

public abstract class RetryContextSupport
implements RetryHandler.RetryContext {
    private static final Logger LOGGER = LoggerManager.get(RetryContextSupport.class);
    private final long maxRetryTime;
    private final long retryIntervals;
    private Long startTime = null;
    private int currentRetryCount = 0;

    protected RetryContextSupport(long maxRetryTime, long retryIntervals) {
        this.maxRetryTime = maxRetryTime;
        this.retryIntervals = retryIntervals;
    }

    protected void assertMaxRetryTime(long maxRetryTime, long minRetryTime) {
        if (maxRetryTime <= minRetryTime) {
            throw new IllegalArgumentException(String.format("maxRetryTime was too short. must be set value greater than minRetryTime to maxRetryTime. minRetryTime = [%s], maxRetryTime = [%s]", minRetryTime, maxRetryTime));
        }
    }

    @Override
    public int getCurrentRetryCount() {
        return this.currentRetryCount;
    }

    @Override
    public boolean isRetryable() {
        if (this.startTime != null) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(String.format("startTime = [%s], maxRetryTime = [%s], elapsedTime = [%s]", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.startTime)), this.maxRetryTime, elapsedTime), new Object[0]);
            }
            if (this.maxRetryTime < elapsedTime) {
                this.reset();
            }
        }
        return this.onIsRetryable();
    }

    protected abstract boolean onIsRetryable();

    @Override
    public void prepareRetry() {
        if (this.startTime == null) {
            this.startTime = System.currentTimeMillis();
        }
        if (0L < this.retryIntervals) {
            try {
                Thread.sleep(this.retryIntervals);
            }
            catch (InterruptedException e) {
                LOGGER.logWarn("interrupted while waiting for retry.", (Throwable)e, new Object[0]);
            }
        }
        ++this.currentRetryCount;
    }

    @Override
    public void reset() {
        this.startTime = null;
        this.currentRetryCount = 0;
    }
}

