/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler.retry;

import nablarch.core.util.annotation.Published;
import nablarch.fw.handler.retry.RetryContextSupport;

@Published(tag={"architect"})
public class TimeRetryContext
extends RetryContextSupport {
    private final long retryTime;
    private long retryStartTime;
    private boolean firstRetry = true;

    protected TimeRetryContext(long retryTime, long maxRetryTime, long retryIntervals) {
        super(maxRetryTime, retryIntervals);
        this.retryTime = retryTime;
        this.assertMaxRetryTime(maxRetryTime, retryTime);
    }

    @Override
    protected boolean onIsRetryable() {
        if (this.firstRetry) {
            return true;
        }
        return System.currentTimeMillis() - this.retryStartTime <= this.retryTime;
    }

    @Override
    public void prepareRetry() {
        if (this.firstRetry) {
            this.firstRetry = false;
            this.retryStartTime = System.currentTimeMillis();
        }
        super.prepareRetry();
    }

    @Override
    public void reset() {
        super.reset();
        this.firstRetry = true;
        this.retryStartTime = 0L;
    }
}

