/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nablarch.core.util.Builder;
import nablarch.core.util.annotation.Published;
import nablarch.fw.Request;
import nablarch.fw.launcher.CommandLineParser;
import nablarch.fw.results.BadRequest;

@Published(tag={"architect"})
public class CommandLine
implements Request<String> {
    private Map<String, String> opts;
    private List<String> args;

    public CommandLine(String ... commandline) {
        CommandLineParser parser = new CommandLineParser();
        CommandLineParser.Result result = parser.parse(commandline);
        this.validateOptions(result.getOpts());
        this.opts = result.getOpts();
        this.args = result.getArgs();
    }

    public CommandLine(Map<String, String> opts, List<String> args) {
        this.validateOptions(opts);
        this.opts = opts;
        this.args = args;
    }

    private void validateOptions(Map<String, String> options) throws IllegalArgumentException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!options.containsKey("diConfig")) {
            errorMessages.add("parameter [-diConfig] must be specified.");
        }
        if (!options.containsKey("requestPath")) {
            errorMessages.add("parameter [-requestPath] must be specified.");
        }
        if (!options.containsKey("userId")) {
            errorMessages.add("parameter [-userId] must be specified.");
        }
        if (!errorMessages.isEmpty()) {
            throw new BadRequest(Builder.join(errorMessages, (String)" / "));
        }
    }

    public String getRequestPath() {
        return this.opts.get("requestPath");
    }

    public CommandLine setRequestPath(String requestPath) {
        this.opts.put("requestPath", requestPath.trim());
        return this;
    }

    @Published
    public String getParam(String name) {
        return this.opts.get(name);
    }

    @Published
    public Map<String, String> getParamMap() {
        return this.opts;
    }

    public CommandLine setParamMap(Map<String, String> opts) {
        this.validateOptions(opts);
        this.opts = opts;
        return this;
    }

    @Published
    public List<String> getArgs() {
        return this.args;
    }
}

