/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    public Result parse(String ... commandLine) {
        HashMap<String, String> opts = new HashMap<String, String>();
        ArrayList<String> args = new ArrayList<String>();
        Iterator<String> itr = Arrays.asList(commandLine).iterator();
        while (itr.hasNext()) {
            String arg = itr.next();
            String optName = arg.replaceAll("^--?", "");
            if (optName.length() != arg.length()) {
                String optValue = itr.hasNext() ? itr.next() : "";
                opts.put(optName, optValue);
                continue;
            }
            args.add(arg);
        }
        return new Result(opts, args);
    }

    public static class Result {
        private final Map<String, String> opts;
        private final List<String> args;

        private Result(Map<String, String> opts, List<String> args) {
            this.opts = opts;
            this.args = args;
        }

        public Map<String, String> getOpts() {
            return this.opts;
        }

        public List<String> getArgs() {
            return this.args;
        }
    }
}

