/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nablarch.core.log.app.ApplicationSettingLogUtil;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.log.app.LogInitializationHelper;
import nablarch.core.log.app.PerformanceLogUtil;
import nablarch.core.repository.ObjectLoader;
import nablarch.core.repository.SystemRepository;
import nablarch.core.repository.di.ComponentDefinitionLoader;
import nablarch.core.repository.di.DiContainer;
import nablarch.core.repository.di.config.DuplicateDefinitionPolicy;
import nablarch.core.repository.di.config.xml.XmlComponentDefinitionLoader;
import nablarch.core.util.annotation.Published;
import nablarch.fw.launcher.CommandLine;
import nablarch.fw.launcher.ProcessLifecycle;

@Published(tag={"architect"})
public class GenericLauncher {
    public static final String PROCESS_LIFECYCLE_KEY = "processLifecycle";
    protected final CommandLine commandLine;

    public static void main(String[] args) {
        new GenericLauncher(args).launch();
    }

    public GenericLauncher(String[] programArguments) {
        this.commandLine = new CommandLine(this.fillDefault(programArguments));
    }

    public void launch() {
        this.initializeLog();
        this.initializeRepository();
        final ProcessLifecycle lifecycle = this.getProcessLifecycle();
        lifecycle.setCommandLine(this.commandLine);
        try {
            lifecycle.initialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    lifecycle.onVirtualMachineShutdown();
                }
            });
            lifecycle.execute();
        }
        finally {
            lifecycle.terminate();
        }
    }

    protected void initializeLog() {
        FailureLogUtil.initialize();
        PerformanceLogUtil.initialize();
        ApplicationSettingLogUtil.initialize();
        LogInitializationHelper.initialize();
    }

    protected void initializeRepository() {
        Map<String, String> options = this.commandLine.getParamMap();
        String configFilePath = options.get("diConfig");
        this.setUpSystemRepository(configFilePath);
    }

    protected ProcessLifecycle getProcessLifecycle() {
        ProcessLifecycle lifecycle = (ProcessLifecycle)SystemRepository.get((String)PROCESS_LIFECYCLE_KEY);
        if (lifecycle == null) {
            throw new IllegalStateException("could not find required component. key=[processLifecycle]");
        }
        return lifecycle;
    }

    protected void setUpSystemRepository(String configFilePath) {
        DiContainer container = new DiContainer((ComponentDefinitionLoader)new XmlComponentDefinitionLoader(configFilePath, DuplicateDefinitionPolicy.OVERRIDE));
        SystemRepository.load((ObjectLoader)container);
    }

    protected String[] fillDefault(String[] orig) {
        String[] params = this.nullToEmpty(orig);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(params));
        this.fillDefault(args, "-requestPath");
        this.fillDefault(args, "-userId");
        return params.length == args.size() ? params : args.toArray(new String[args.size()]);
    }

    protected String[] nullToEmpty(String[] strings) {
        return strings == null ? new String[]{} : strings;
    }

    protected void fillDefault(List<String> args, String key) {
        if (args.contains(key)) {
            return;
        }
        args.add(key);
        args.add("");
    }
}

