/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.ApplicationSettingLogUtil;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.log.app.LogInitializationHelper;
import nablarch.core.log.app.PerformanceLogUtil;
import nablarch.core.repository.ObjectLoader;
import nablarch.core.repository.SystemRepository;
import nablarch.core.repository.di.ComponentDefinitionLoader;
import nablarch.core.repository.di.DiContainer;
import nablarch.core.repository.di.config.DuplicateDefinitionPolicy;
import nablarch.core.repository.di.config.xml.XmlComponentDefinitionLoader;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.DataReader;
import nablarch.fw.DataReaderFactory;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.HandlerQueueManager;
import nablarch.fw.MethodBinder;
import nablarch.fw.Result;
import nablarch.fw.StandaloneExecutionContext;
import nablarch.fw.handler.RecordTypeBinding;
import nablarch.fw.launcher.CommandLine;
import nablarch.fw.launcher.logging.LauncherLogUtil;

public class Main
extends HandlerQueueManager<Main>
implements Handler<CommandLine, Integer> {
    private static final Logger LOGGER = LoggerManager.get(Main.class);
    private List<Handler> handlerQueue = new ArrayList<Handler>();
    private static final int UNKNOWN_ERROR = 127;

    public List<Handler> getHandlerQueue() {
        return this.handlerQueue;
    }

    public static void main(String ... args) {
        CommandLine commandLine = new CommandLine(args);
        LauncherLogUtil.initialize();
        LOGGER.logInfo(LauncherLogUtil.getStartLogMsg(commandLine), new Object[0]);
        long executeStartTime = System.currentTimeMillis();
        int exitCode = Main.execute(commandLine);
        long executeEndTime = System.currentTimeMillis();
        LOGGER.logInfo(LauncherLogUtil.getEndLogMsg(exitCode, executeEndTime - executeStartTime), new Object[0]);
        System.exit(exitCode);
    }

    public Integer handle(CommandLine commandLine, ExecutionContext context) {
        Object result;
        FailureLogUtil.initialize();
        try {
            this.initializeLog();
            this.setupExecutionContext(commandLine, context);
            LOGGER.logInfo(ApplicationSettingLogUtil.getAppSettingsWithDateLogMsg(), new Object[0]);
            result = context.handleNext((Object)commandLine);
        }
        catch (Result.Error e) {
            FailureLogUtil.logFatal((Throwable)e, null, null, (Object[])new Object[0]);
            result = e;
        }
        catch (RuntimeException e) {
            FailureLogUtil.logFatal((Throwable)e, null, null, (Object[])new Object[0]);
            return 127;
        }
        catch (Error e) {
            FailureLogUtil.logFatal((Throwable)e, null, null, (Object[])new Object[0]);
            return 127;
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Result.Success) {
            return 0;
        }
        if (result instanceof Result) {
            int statusCode = ((Result)result).getStatusCode();
            return statusCode >= 0 && statusCode <= 127 ? statusCode : 127;
        }
        return 0;
    }

    @Published(tag={"architect"})
    public static int execute(CommandLine commandLine) {
        Main launcher = new Main();
        StandaloneExecutionContext ctx = new StandaloneExecutionContext();
        return launcher.handle(commandLine, (ExecutionContext)ctx);
    }

    protected Main setupExecutionContext(CommandLine commandLine, ExecutionContext context) {
        Map<String, String> options = commandLine.getParamMap();
        String configFilePath = options.remove("diConfig");
        if (StringUtil.isNullOrEmpty((String)configFilePath)) {
            throw new IllegalArgumentException("diConfig option must be specified.");
        }
        this.setUpSystemRepository(configFilePath);
        this.handlerQueue = (List)SystemRepository.get((String)"handlerQueue");
        DataReader reader = (DataReader)SystemRepository.get((String)"dataReader");
        DataReaderFactory readerFactory = (DataReaderFactory)SystemRepository.get((String)"dataReaderFactory");
        ((ExecutionContext)((ExecutionContext)context.setHandlerQueue(this.handlerQueue)).setDataReader(reader).setDataReaderFactory(readerFactory).setSessionScopedVar("user.id", (Object)commandLine.getParam("userId")).setMethodBinder((MethodBinder)new RecordTypeBinding.Binder())).getSessionScopeMap().putAll(commandLine.getParamMap());
        return this;
    }

    protected void setUpSystemRepository(String configFilePath) {
        DiContainer container = new DiContainer((ComponentDefinitionLoader)new XmlComponentDefinitionLoader(configFilePath, DuplicateDefinitionPolicy.OVERRIDE));
        SystemRepository.load((ObjectLoader)container);
    }

    protected void initializeLog() {
        PerformanceLogUtil.initialize();
        ApplicationSettingLogUtil.initialize();
        LogInitializationHelper.initialize();
    }
}

