/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.core.log.LogItem;
import nablarch.core.log.LogUtil;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.launcher.CommandLine;

@Published(tag={"architect"})
public class LauncherLogFormatter {
    public static final String PROPS_PREFIX = "launcherLogFormatter.";
    private static final String DEFAULT_START_LOG_FORMAT = "@@@@ BEGIN @@@@\n\tcommand line options = {$commandLineOptions$\n\t}\n\tcommand line arguments = {$commandLineArguments$\n\t}";
    private static final String DEFAULT_END_LOG_FORMAT = "@@@@ END @@@@ exit code = [$exitCode$] execute time(ms) = [$executeTime$]";
    private final Map<String, LogItem<LauncherLogContext>> startLogItems = this.getStartLogItems();
    private final Map<String, LogItem<LauncherLogContext>> endLogItems = this.getEndLogItems();

    public String getStartLogMsg(CommandLine commandLine) {
        LogItem[] items = LogUtil.createFormattedLogItems(this.startLogItems, (String)this.getStartLogFormat());
        LauncherLogContext context = new LauncherLogContext();
        context.setCommandLine(commandLine);
        return LogUtil.formatMessage((LogItem[])items, (Object)context);
    }

    public String getEndLogMsg(int exitCode, long executeTime) {
        LogItem[] items = LogUtil.createFormattedLogItems(this.endLogItems, (String)this.getEndLogFormat());
        LauncherLogContext context = new LauncherLogContext();
        context.setExitCode(exitCode);
        context.setExecuteTime(executeTime);
        return LogUtil.formatMessage((LogItem[])items, (Object)context);
    }

    protected String getStartLogFormat() {
        String overrideFormat = (String)AppLogUtil.getProps().get("launcherLogFormatter.startFormat");
        if (overrideFormat == null) {
            return DEFAULT_START_LOG_FORMAT;
        }
        return overrideFormat;
    }

    protected Map<String, LogItem<LauncherLogContext>> getStartLogItems() {
        HashMap<String, LogItem<LauncherLogContext>> logItem = new HashMap<String, LogItem<LauncherLogContext>>();
        logItem.put("$commandLineOptions$", new CommandLineOptions());
        logItem.put("$commandLineArguments$", new CommandLineArguments());
        return logItem;
    }

    protected Map<String, LogItem<LauncherLogContext>> getEndLogItems() {
        HashMap<String, LogItem<LauncherLogContext>> logItem = new HashMap<String, LogItem<LauncherLogContext>>();
        logItem.put("$exitCode$", new ExitCode());
        logItem.put("$executeTime$", new ExecuteTime());
        return logItem;
    }

    protected String getEndLogFormat() {
        String overrideFormat = (String)AppLogUtil.getProps().get("launcherLogFormatter.endFormat");
        if (overrideFormat == null) {
            return DEFAULT_END_LOG_FORMAT;
        }
        return overrideFormat;
    }

    protected static class ExecuteTime
    implements LogItem<LauncherLogContext> {
        protected ExecuteTime() {
        }

        public String get(LauncherLogContext context) {
            return String.valueOf(context.getExecuteTime());
        }
    }

    protected static class ExitCode
    implements LogItem<LauncherLogContext> {
        protected ExitCode() {
        }

        public String get(LauncherLogContext context) {
            return String.valueOf(context.getExitCode());
        }
    }

    protected static class CommandLineArguments
    implements LogItem<LauncherLogContext> {
        protected CommandLineArguments() {
        }

        public String get(LauncherLogContext context) {
            List<String> arguments = context.getCommandLine().getArgs();
            StringBuilder result = new StringBuilder();
            int size = arguments.size();
            for (int i = 0; i < size; ++i) {
                String argument = arguments.get(i);
                result.append('\n');
                result.append("\t\t");
                result.append(StringUtil.lpad((String)String.valueOf(i + 1), (int)2, (char)'0'));
                result.append(" = [");
                result.append(argument);
                result.append(']');
            }
            return result.toString();
        }
    }

    protected static class CommandLineOptions
    implements LogItem<LauncherLogContext> {
        protected CommandLineOptions() {
        }

        public String get(LauncherLogContext context) {
            CommandLine line = context.getCommandLine();
            StringBuilder result = new StringBuilder();
            Map<String, String> paramMap = line.getParamMap();
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result.append('\n');
                result.append("\t\t");
                result.append(key);
                result.append(" = [");
                result.append(value);
                result.append(']');
            }
            return result.toString();
        }
    }

    protected static class LauncherLogContext {
        private CommandLine commandLine;
        private int exitCode;
        private long executeTime;

        protected LauncherLogContext() {
        }

        protected CommandLine getCommandLine() {
            return this.commandLine;
        }

        protected void setCommandLine(CommandLine commandLine) {
            this.commandLine = commandLine;
        }

        protected int getExitCode() {
            return this.exitCode;
        }

        protected void setExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        protected long getExecuteTime() {
            return this.executeTime;
        }

        protected void setExecuteTime(long executeTime) {
            this.executeTime = executeTime;
        }
    }
}

