/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.launcher.logging;

import java.util.Map;
import nablarch.core.log.LogUtil;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.ObjectUtil;
import nablarch.fw.launcher.CommandLine;
import nablarch.fw.launcher.logging.LauncherLogFormatter;

public final class LauncherLogUtil {
    private static final String PROPS_CLASS_NAME = "launcherLogFormatter.className";
    private static final LogUtil.ObjectCreator<LauncherLogFormatter> LAUNCHER_LOG_FORMATTER_CREATOR = new LogUtil.ObjectCreator<LauncherLogFormatter>(){

        public LauncherLogFormatter create() {
            LauncherLogFormatter formatter;
            Map props = AppLogUtil.getProps();
            if (props.containsKey(LauncherLogUtil.PROPS_CLASS_NAME)) {
                String className = (String)props.get(LauncherLogUtil.PROPS_CLASS_NAME);
                formatter = (LauncherLogFormatter)ObjectUtil.createInstance((String)className);
            } else {
                formatter = new LauncherLogFormatter();
            }
            return formatter;
        }
    };

    private LauncherLogUtil() {
    }

    public static void initialize() {
        LauncherLogUtil.getLogFormatter();
    }

    private static LauncherLogFormatter getLogFormatter() {
        return (LauncherLogFormatter)LogUtil.getObjectBoundToClassLoader(LAUNCHER_LOG_FORMATTER_CREATOR);
    }

    public static String getStartLogMsg(CommandLine commandLine) {
        return LauncherLogUtil.getLogFormatter().getStartLogMsg(commandLine);
    }

    public static String getEndLogMsg(int exitCode, long executeTime) {
        return LauncherLogUtil.getLogFormatter().getEndLogMsg(exitCode, executeTime);
    }
}

