/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.sql.Timestamp;
import nablarch.common.web.session.Expiration;
import nablarch.common.web.session.store.UserSessionSchema;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.fw.ExecutionContext;

public class DbManagedExpiration
implements Expiration,
Initializable {
    private SimpleDbTransactionManager dbManager;
    private UserSessionSchema userSessionSchema;
    private String selectUserSessionSql;
    private String insertUserSessionSql;
    private String updateUserSessionSql;
    private String countUserSessionSql;
    private static final String COUNT = "COUNT_";

    public void setDbManager(SimpleDbTransactionManager dbManager) {
        this.dbManager = dbManager;
    }

    public void setUserSessionSchema(UserSessionSchema userSessionSchema) {
        this.userSessionSchema = userSessionSchema;
    }

    public boolean isExpired(final String sessionId, long currentDateTime, ExecutionContext context) {
        SqlResultSet sessionRecords = (SqlResultSet)new SimpleDbTransactionExecutor<SqlResultSet>(this.dbManager){

            public SqlResultSet execute(AppDbConnection connection) {
                SqlPStatement prepared = connection.prepareStatement(DbManagedExpiration.this.selectUserSessionSql);
                prepared.setString(1, sessionId);
                return prepared.retrieve();
            }
        }.doTransaction();
        if (sessionRecords == null || sessionRecords.isEmpty()) {
            return true;
        }
        long expiration = ((SqlRow)sessionRecords.get(0)).getTimestamp(this.userSessionSchema.getExpirationDatetimeName()).getTime();
        return expiration < currentDateTime;
    }

    public void saveExpirationDateTime(final String sessionId, final long expirationDateTime, ExecutionContext context) {
        new SimpleDbTransactionExecutor<Void>(this.dbManager){

            public Void execute(AppDbConnection connection) {
                int count = DbManagedExpiration.this.updateSessionExpiration(sessionId, expirationDateTime, connection);
                if (count == 0) {
                    DbManagedExpiration.this.insertSessionExpiration(sessionId, expirationDateTime, connection);
                }
                return null;
            }
        }.doTransaction();
    }

    public boolean isDeterminable(final String sessionId, ExecutionContext context) {
        return (Boolean)new SimpleDbTransactionExecutor<Boolean>(this.dbManager){

            public Boolean execute(AppDbConnection connection) {
                SqlPStatement prepared = connection.prepareStatement(DbManagedExpiration.this.countUserSessionSql);
                prepared.setString(1, sessionId);
                return ((SqlRow)prepared.retrieve().get(0)).getInteger(DbManagedExpiration.COUNT) > 0;
            }
        }.doTransaction();
    }

    private int updateSessionExpiration(String sessionId, long expirationDateTime, AppDbConnection connection) {
        SqlPStatement update = connection.prepareStatement(this.updateUserSessionSql);
        update.setTimestamp(1, new Timestamp(expirationDateTime));
        update.setString(2, sessionId);
        return update.executeUpdate();
    }

    private void insertSessionExpiration(String sessionId, long expirationDateTime, AppDbConnection connection) {
        SqlPStatement insertStatement = connection.prepareStatement(this.insertUserSessionSql);
        insertStatement.setString(1, sessionId);
        insertStatement.setTimestamp(2, new Timestamp(expirationDateTime));
        insertStatement.executeUpdate();
    }

    public void initialize() {
        if (this.userSessionSchema == null) {
            this.userSessionSchema = new UserSessionSchema();
            this.userSessionSchema.setTableName("USER_SESSION");
            this.userSessionSchema.setSessionIdName("SESSION_ID");
            this.userSessionSchema.setExpirationDatetimeName("EXPIRATION_DATETIME");
        }
        this.selectUserSessionSql = "SELECT " + this.userSessionSchema.getExpirationDatetimeName() + " FROM " + this.userSessionSchema.getTableName() + " WHERE " + this.userSessionSchema.getSessionIdName() + " = ? ";
        this.countUserSessionSql = "SELECT COUNT(" + this.userSessionSchema.getExpirationDatetimeName() + ") " + COUNT + " FROM (" + this.selectUserSessionSql + ") SUB_";
        this.insertUserSessionSql = "INSERT INTO " + this.userSessionSchema.getTableName() + " ( " + this.userSessionSchema.getSessionIdName() + ", " + this.userSessionSchema.getExpirationDatetimeName() + ") VALUES (?,?)";
        this.updateUserSessionSql = "UPDATE " + this.userSessionSchema.getTableName() + " SET " + this.userSessionSchema.getExpirationDatetimeName() + "=? WHERE " + this.userSessionSchema.getSessionIdName() + " = ?";
    }
}

