/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.store;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionStore;
import nablarch.common.web.session.store.UserSessionSchema;
import nablarch.core.date.SystemTimeUtil;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.statement.ResultSetIterator;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.exception.DuplicateStatementException;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.fw.ExecutionContext;

public class DbStore
extends SessionStore
implements Initializable {
    private SimpleDbTransactionManager dbManager;
    private UserSessionSchema userSessionSchema;
    private String selectUserSessionSql;
    private String insertUserSessionSql;
    private String updateUserSessionSql;
    private String deleteUserSessionSql;

    public DbStore() {
        super("db");
    }

    public void setDbManager(SimpleDbTransactionManager dbManager) {
        this.dbManager = dbManager;
    }

    public void setUserSessionSchema(UserSessionSchema userSessionSchema) {
        this.userSessionSchema = userSessionSchema;
    }

    public List<SessionEntry> load(final String sessionId, ExecutionContext executionContext) {
        return (List)new SimpleDbTransactionExecutor<List<SessionEntry>>(this.dbManager){

            public List<SessionEntry> execute(AppDbConnection connection) {
                SqlPStatement prepared = connection.prepareStatement(DbStore.this.selectUserSessionSql);
                prepared.setString(1, sessionId);
                prepared.setTimestamp(2, new Timestamp(SystemTimeUtil.getTimestamp().getTime()));
                ResultSetIterator iterator = prepared.executeQuery();
                if (iterator.next()) {
                    byte[] sessionObject = iterator.getBytes(1);
                    return sessionObject == null ? Collections.emptyList() : DbStore.this.decode(sessionObject);
                }
                return Collections.emptyList();
            }
        }.doTransaction();
    }

    public void save(String sessionId, List<SessionEntry> entries, ExecutionContext executionContext) {
        try {
            this.saveSession(sessionId, entries);
        }
        catch (DuplicateStatementException e) {
            this.saveSession(sessionId, entries);
        }
    }

    public void delete(final String sessionId, ExecutionContext executionContext) {
        new SimpleDbTransactionExecutor<Void>(this.dbManager){

            public Void execute(AppDbConnection connection) {
                DbStore.this.deleteUserSession(sessionId, connection);
                return null;
            }
        }.doTransaction();
    }

    public void invalidate(String sessionId, ExecutionContext executionContext) {
        this.delete(sessionId, executionContext);
    }

    private void saveSession(final String sessionId, final List<SessionEntry> entries) {
        new SimpleDbTransactionExecutor<Void>(this.dbManager){

            public Void execute(AppDbConnection connection) {
                if (entries == null || entries.isEmpty()) {
                    DbStore.this.deleteUserSession(sessionId, connection);
                    return null;
                }
                int count = DbStore.this.updateUserSession(sessionId, entries, connection);
                if (count == 0) {
                    DbStore.this.insertUserSession(sessionId, entries, connection);
                }
                return null;
            }
        }.doTransaction();
    }

    private int updateUserSession(String sessionId, List<SessionEntry> entries, AppDbConnection connection) {
        SqlPStatement update = connection.prepareStatement(this.updateUserSessionSql);
        update.setBytes(1, this.encode(entries));
        update.setTimestamp(2, new Timestamp(SystemTimeUtil.getTimestamp().getTime() + this.getExpiresMilliSeconds()));
        update.setString(3, sessionId);
        return update.executeUpdate();
    }

    private void insertUserSession(String sessionId, List<SessionEntry> entries, AppDbConnection connection) {
        SqlPStatement insertStatement = connection.prepareStatement(this.insertUserSessionSql);
        insertStatement.setString(1, sessionId);
        insertStatement.setBytes(2, this.encode(entries));
        insertStatement.setTimestamp(3, new Timestamp(SystemTimeUtil.getTimestamp().getTime() + this.getExpiresMilliSeconds()));
        insertStatement.executeUpdate();
    }

    private void deleteUserSession(String sessionId, AppDbConnection connection) {
        SqlPStatement deleteStatement = connection.prepareStatement(this.deleteUserSessionSql);
        deleteStatement.setString(1, sessionId);
        deleteStatement.executeUpdate();
    }

    public void initialize() {
        if (this.userSessionSchema == null) {
            this.userSessionSchema = new UserSessionSchema();
            this.userSessionSchema.setTableName("USER_SESSION");
            this.userSessionSchema.setSessionIdName("SESSION_ID");
            this.userSessionSchema.setSessionObjectName("SESSION_OBJECT");
            this.userSessionSchema.setExpirationDatetimeName("EXPIRATION_DATETIME");
        }
        this.selectUserSessionSql = "SELECT " + this.userSessionSchema.getSessionObjectName() + " FROM " + this.userSessionSchema.getTableName() + "  WHERE " + this.userSessionSchema.getSessionIdName() + " = ?  AND " + this.userSessionSchema.getExpirationDatetimeName() + " >= ?";
        this.insertUserSessionSql = "INSERT INTO " + this.userSessionSchema.getTableName() + " ( " + this.userSessionSchema.getSessionIdName() + ", " + this.userSessionSchema.getSessionObjectName() + ", " + this.userSessionSchema.getExpirationDatetimeName() + ") VALUES (?,?,?)";
        this.deleteUserSessionSql = "DELETE FROM " + this.userSessionSchema.getTableName() + " WHERE " + this.userSessionSchema.getSessionIdName() + " = ?";
        this.updateUserSessionSql = "UPDATE " + this.userSessionSchema.getTableName() + " SET " + this.userSessionSchema.getSessionObjectName() + "=?," + this.userSessionSchema.getExpirationDatetimeName() + "=? WHERE " + this.userSessionSchema.getSessionIdName() + " = ?";
    }
}

