/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.download;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpResponse;

public class DataRecordResponse
extends HttpResponse {
    private final ByteArrayOutputStream dest = new ByteArrayOutputStream();
    private final DataRecordFormatter formatter;

    @Published
    public DataRecordResponse(String basePathName, String fileName) {
        File layoutFile = FilePathSetting.getInstance().getFileWithoutCreate(basePathName, fileName);
        this.formatter = FormatterFactory.getInstance().createFormatter(layoutFile);
        this.formatter.setOutputStream((OutputStream)this.dest).initialize();
    }

    @Published
    public void write(Map<String, ?> record) {
        try {
            this.formatter.writeRecord(record);
            this.write(this.dest.toByteArray());
            this.dest.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("an error occurred while writing a record. record = [%s]", record), e);
        }
    }

    @Published
    public void write(String recordType, Map<String, ?> record) {
        try {
            this.formatter.writeRecord(recordType, record);
            this.write(this.dest.toByteArray());
            this.dest.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("an error occurred while writing a record. recordType = [%s], record = [%s]", recordType, record), e);
        }
    }

    public HttpResponse cleanup() {
        FileUtil.closeQuietly((Closeable[])new Closeable[]{this.dest});
        return super.cleanup();
    }
}

