/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;

public class FileResponse
extends HttpResponse {
    private final File file;
    private final boolean deleteOnCleanup;

    @Published
    public FileResponse(File file) {
        this(file, false);
    }

    @Published
    public FileResponse(File file, boolean deleteOnCleanup) {
        if (file == null) {
            throw new IllegalArgumentException("file is required.");
        }
        this.file = file;
        this.deleteOnCleanup = deleteOnCleanup;
        this.setHeader("Content-Length", String.valueOf(file.length()));
    }

    public String getContentLength() {
        return this.getHeader("Content-Length");
    }

    @Published(tag={"architect"})
    public boolean isBodyEmpty() {
        return false;
    }

    public String getBodyString() {
        throw new UnsupportedOperationException("unsupported.");
    }

    @Published(tag={"architect"})
    public InputStream getBodyStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse cleanup() {
        if (this.deleteOnCleanup) {
            this.file.delete();
        }
        return this;
    }

    public ResourceLocator getContentPath() {
        return null;
    }

    public HttpResponse setBodyStream(InputStream bodyStream) {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse setContentPath(String path) {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse setContentPath(ResourceLocator resource) {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse write(CharSequence text) {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse write(byte[] bytes) {
        throw new UnsupportedOperationException("unsupported.");
    }

    public HttpResponse write(ByteBuffer bytes) {
        throw new UnsupportedOperationException("unsupported.");
    }
}

