/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.download;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResponseBody;

public class StreamResponse
extends HttpResponse {
    @Published
    public StreamResponse(Blob blob) {
        try {
            this.initialize(blob.getBinaryStream());
        }
        catch (SQLException e) {
            throw new RuntimeException("an error occurred while initializing a response.", e);
        }
    }

    private void initialize(InputStream inputStream) {
        byte[] src = new byte[512];
        try {
            int length;
            while ((length = inputStream.read(src)) != -1) {
                byte[] dest = new byte[length];
                System.arraycopy(src, 0, dest, 0, length);
                this.write(dest);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("an error occurred while writing a response.", e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{inputStream});
    }

    @Published
    public StreamResponse(File file, boolean deleteOnCleanup) {
        if (deleteOnCleanup) {
            ResponseBody.addTempFileToDelete((File)file);
        }
        this.setContentPath("file://" + file.getAbsolutePath());
    }
}

