/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published
public final class BinaryUtil {
    private BinaryUtil() {
    }

    public static byte[] convertToBytes(String original, int length, Charset encoding) {
        byte[] bytes = BinaryUtil.convertToBytes(original, encoding);
        return BinaryUtil.fillZerosRight(bytes, length);
    }

    public static String convertToHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(bytes.length / 2);
        for (byte b : bytes) {
            char[] hex = new char[]{Character.forDigit(b >> 4 & 0xF, 16), Character.forDigit(b & 0xF, 16)};
            sb.append(hex);
        }
        return sb.toString().toUpperCase();
    }

    public static String convertToHexStringWithPrefix(byte[] bytes) {
        String bareValue = BinaryUtil.convertToHexString(bytes);
        if (bareValue.length() == 0 || bareValue.equals("null")) {
            return "";
        }
        return "0x" + bareValue;
    }

    public static byte[] convertToBytes(String original, Charset encoding) throws NumberFormatException {
        if (StringUtil.isNullOrEmpty((String)original)) {
            return new byte[0];
        }
        if (!original.startsWith("0x")) {
            return StringUtil.getBytes((String)original, (Charset)encoding);
        }
        String hex = original.substring(2);
        return BinaryUtil.convertHexToBytes(hex);
    }

    public static byte[] convertHexToBytes(String hexString) {
        if (StringUtil.isNullOrEmpty((String)hexString)) {
            throw new NumberFormatException("invalid hexadecimal expression. [" + hexString + "]");
        }
        int length = hexString.length();
        if (length % 2 != 0) {
            hexString = "0" + hexString;
            ++length;
        }
        byte[] result = new byte[length / 2];
        for (int i = 0; i < length / 2; ++i) {
            int startIndex = i * 2;
            String hex = hexString.substring(startIndex, startIndex + 2);
            try {
                result[i] = (byte)Integer.parseInt(hex, 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("invalid hexadecimal expression. [" + hexString + "] :" + e.getMessage());
            }
        }
        return result;
    }

    public static byte[] fillZerosRight(byte[] orig, int length) {
        if (orig.length == 0 || orig.length >= length) {
            return orig;
        }
        byte[] result = new byte[length];
        System.arraycopy(orig, 0, result, 0, orig.length);
        return result;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(inputStream);
        try {
            int b;
            while ((b = ((InputStream)in).read()) != -1) {
                out.write(b);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
        return out.toByteArray();
    }
}

