/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.message.MessageLevel;
import nablarch.core.message.MessageUtil;
import nablarch.core.validation.ValidationContext;
import nablarch.core.validation.ValidationUtil;
import nablarch.fw.web.upload.util.BulkValidator;
import nablarch.fw.web.upload.util.ValidatingStrategy;

public class BasicValidatingStrategy<FORM>
implements ValidatingStrategy<FORM> {
    private final Class<FORM> formClass;
    private final String validateFor;
    private BulkValidator.ErrorHandlingBulkValidator msgIds;

    public BasicValidatingStrategy(Class<FORM> formClass, String validateFor, BulkValidator.ErrorHandlingBulkValidator msgIds) {
        this.validateFor = validateFor;
        this.formClass = formClass;
        this.msgIds = msgIds;
    }

    @Override
    public ValidationContext<FORM> validateRecord(DataRecord dataRecord) {
        return ValidationUtil.validateAndConvertRequest(this.formClass, (Map)dataRecord, (String)this.validateFor);
    }

    @Override
    public List<Message> handleInvalidRecord(DataRecord errorRecord, ValidationContext<FORM> context) {
        ArrayList<Message> result = new ArrayList<Message>(context.getMessages().size());
        for (Message e : context.getMessages()) {
            Message edited = MessageUtil.createMessage((MessageLevel)MessageLevel.ERROR, (String)this.msgIds.msgIdOnValidationError, (Object[])new Object[]{errorRecord.getRecordNumber(), e.formatMessage()});
            result.add(edited);
        }
        return result;
    }

    @Override
    public Message handleInvalidFormatRecord(InvalidDataFormatException e) {
        return MessageUtil.createMessage((MessageLevel)MessageLevel.ERROR, (String)this.msgIds.msgIdOnFormatError, (Object[])new Object[]{e.getRecordNumber()});
    }

    @Override
    public void handleEmptyFile(String fileName) {
        throw new ApplicationException(MessageUtil.createMessage((MessageLevel)MessageLevel.ERROR, (String)this.msgIds.msgIdOnEmptyFile, (Object[])new Object[]{fileName}));
    }
}

