/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import nablarch.core.db.statement.ParameterizedSqlPStatement;
import nablarch.core.db.support.DbAccessSupport;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.upload.util.InsertionStrategy;

public class BulkValidationResult<FORM> {
    private static final int BATCH_SIZE = 100;
    private final List<FORM> validObjects = new ArrayList<FORM>();
    private ErrorMessages errorMessages = new ErrorMessages();
    private final int batchSize;

    BulkValidationResult() {
        this(100);
    }

    BulkValidationResult(int batchSize) {
        this.batchSize = batchSize;
    }

    @Published
    public boolean hasError() {
        return !this.errorMessages.isEmpty();
    }

    @Published
    public ErrorMessages getErrorMessages() {
        return this.errorMessages;
    }

    public boolean isEmpty() {
        return this.validObjects.isEmpty() && this.errorMessages.isEmpty();
    }

    public List<FORM> getValidObjects() throws ApplicationException {
        if (this.hasError()) {
            List<Message> all = this.errorMessages.getAllMessages();
            throw new ApplicationException(all);
        }
        return this.validObjects;
    }

    @Published
    public int importWith(final DbAccessSupport dbAccessSupport, final String insertSqlId) {
        InsertionStrategy strategy = new InsertionStrategy<FORM>(){

            @Override
            public ParameterizedSqlPStatement prepareStatement(FORM form) {
                return dbAccessSupport.getParameterizedSqlStatement(insertSqlId, form);
            }

            @Override
            public void addBatch(ParameterizedSqlPStatement statement, FORM form) {
                statement.addBatchObject(form);
            }
        };
        return this.importAll(strategy);
    }

    @Published
    public int importAll(InsertionStrategy<FORM> strategy) {
        List<FORM> validObjects = this.getValidObjects();
        if (validObjects.isEmpty()) {
            return 0;
        }
        ParameterizedSqlPStatement statement = strategy.prepareStatement(validObjects.get(0));
        int cnt = 0;
        for (FORM e : validObjects) {
            boolean timeToExec;
            strategy.addBatch(statement, e);
            if (!(timeToExec = this.isTimeToExecBatch(++cnt))) continue;
            statement.executeBatch();
        }
        if (!this.isTimeToExecBatch(cnt)) {
            statement.executeBatch();
        }
        return cnt;
    }

    private boolean isTimeToExecBatch(int cnt) {
        return cnt % this.batchSize == 0;
    }

    void addValidObject(FORM validObject) {
        this.validObjects.add(validObject);
    }

    void addErrors(int recordNumber, List<Message> messages) {
        this.errorMessages.put(recordNumber, messages);
    }

    void addError(Integer recordNumber, Message message) {
        this.errorMessages.put(recordNumber, Arrays.asList(message));
    }

    public static class ErrorMessages
    extends TreeMap<Integer, List<Message>> {
        @Published
        public List<Message> getAllMessages() {
            return ErrorMessages.flatten(this.values());
        }

        private static <V> List<V> flatten(Collection<? extends Collection<V>> orig) {
            ArrayList<V> result = new ArrayList<V>();
            for (Collection<V> e : orig) {
                result.addAll(e);
            }
            return result;
        }
    }
}

