/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.message.Message;
import nablarch.core.util.Builder;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.core.validation.ValidationContext;
import nablarch.fw.web.upload.util.BasicValidatingStrategy;
import nablarch.fw.web.upload.util.BulkValidationResult;
import nablarch.fw.web.upload.util.ValidatingStrategy;

public class BulkValidator {
    private static final Logger LOGGER = LoggerManager.get(BulkValidator.class);
    private final DataRecordFormatter formatter;
    private final String fileName;

    BulkValidator(DataRecordFormatter formatter, String fileName) {
        this.formatter = formatter;
        this.fileName = fileName;
    }

    public DataRecordFormatter getFormatter() {
        return this.formatter;
    }

    @Published
    public <FORM> BulkValidationResult<FORM> validateAll(ValidatingStrategy<FORM> validatingStrategy) {
        return new BulkValidationDriver<FORM>(validatingStrategy, this.formatter, this.fileName).validateAll();
    }

    @Published
    public ErrorHandlingBulkValidator setUpMessageIdOnError(String messageIdOnFormatError, String messageIdOnValidationError, String messageIdOnEmptyFile) {
        return new ErrorHandlingBulkValidator(this, messageIdOnFormatError, messageIdOnValidationError, messageIdOnEmptyFile);
    }

    static class BulkValidationDriver<FORM> {
        private final BulkValidationResult<FORM> result = new BulkValidationResult();
        private final ValidatingStrategy<FORM> strategy;
        private final DataRecordFormatter formatter;
        private final String fileName;

        BulkValidationDriver(ValidatingStrategy<FORM> strategy, DataRecordFormatter formatter, String fileName) {
            this.strategy = strategy;
            this.formatter = formatter;
            this.fileName = fileName;
        }

        BulkValidationResult<FORM> validateAll() {
            try {
                this.validateAllRecord();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly((Closeable[])new Closeable[]{this.formatter});
                    throw throwable;
                }
            }
            FileUtil.closeQuietly((Closeable[])new Closeable[]{this.formatter});
            if (this.result.isEmpty()) {
                this.strategy.handleEmptyFile(this.fileName);
            }
            return this.result;
        }

        private void validateAllRecord() throws IOException {
            while (this.formatter.hasNext()) {
                DataRecord dataRecord = null;
                try {
                    dataRecord = this.formatter.readRecord();
                    ValidationContext<FORM> context = this.strategy.validateRecord(dataRecord);
                    this.logRecord(dataRecord, context);
                    if (context.isValid()) {
                        this.result.addValidObject(context.createObject());
                        continue;
                    }
                    this.logValidationError(dataRecord, context);
                    List<Message> messages = this.strategy.handleInvalidRecord(dataRecord, context);
                    this.result.addErrors(dataRecord.getRecordNumber(), messages);
                }
                catch (InvalidDataFormatException e) {
                    this.logFormatError(e);
                    this.result.addError(e.getRecordNumber(), this.strategy.handleInvalidFormatRecord(e));
                }
            }
        }

        private void logRecord(DataRecord dataRecord, ValidationContext<FORM> context) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(Builder.concat((Object[])new Object[]{"invoking validation .", " line=[", dataRecord.getRecordNumber(), "]", " class=[", context.getTargetClass().getName(), "]", " validateFor=[", context.getValidateFor(), "]", " record=", dataRecord}), new Object[0]);
            }
        }

        private void logValidationError(DataRecord errorRecord, ValidationContext<FORM> context) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(Builder.concat((Object[])new Object[]{"   validation error .", " line=[", errorRecord.getRecordNumber(), "]", " messages=", context.getMessages()}), new Object[0]);
            }
        }

        private void logFormatError(InvalidDataFormatException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(Builder.concat((Object[])new Object[]{"       format error . ", "line=[", e.getRecordNumber(), "] ", "fieldName=[", e.getFieldName(), "] ", e.getMessage()}), new Object[0]);
            }
        }
    }

    public static final class ErrorHandlingBulkValidator {
        private final BulkValidator bulkValidator;
        final String msgIdOnFormatError;
        final String msgIdOnValidationError;
        final String msgIdOnEmptyFile;

        ErrorHandlingBulkValidator(BulkValidator validator, String onFormatError, String onValidationError, String onEmptyFile) {
            this.bulkValidator = validator;
            this.msgIdOnFormatError = onFormatError;
            this.msgIdOnValidationError = onValidationError;
            this.msgIdOnEmptyFile = onEmptyFile;
        }

        @Published
        public <F> BulkValidationResult<F> validateWith(Class<F> formClass, String validateFor) {
            BasicValidatingStrategy<F> strategy = new BasicValidatingStrategy<F>(formClass, validateFor, this);
            return this.bulkValidator.validateAll(strategy);
        }
    }
}

