/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.dataformat.SyntaxErrorException;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.BinaryUtil;
import nablarch.core.util.Builder;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.upload.PartInfo;
import nablarch.fw.web.upload.util.BulkValidator;

public class UploadHelper {
    private static final Logger LOGGER = LoggerManager.get(UploadHelper.class);
    private final PartInfo partInfo;

    @Published
    public UploadHelper(PartInfo partInfo) {
        this.partInfo = partInfo;
    }

    @Published
    public void moveFileTo(String basePathName, String fileName) {
        FilePathSetting setting = FilePathSetting.getInstance();
        File dir = setting.getBaseDirectory(basePathName);
        this.partInfo.moveTo(dir, fileName);
    }

    @Published
    public BulkValidator applyFormat(String layoutFileName) {
        return this.applyFormat("format", layoutFileName);
    }

    @Published
    public BulkValidator applyFormat(String basePathName, String layoutFileName) {
        DataRecordFormatter formatter;
        this.logContentOfUploaded();
        File layoutFile = this.getLayoutFile(basePathName, layoutFileName);
        BufferedInputStream in = new BufferedInputStream(this.partInfo.getInputStream());
        try {
            formatter = FormatterFactory.getInstance().createFormatter(layoutFile).setInputStream((InputStream)in).initialize();
        }
        catch (SyntaxErrorException e) {
            throw this.createApplyFormatException(basePathName, layoutFileName, layoutFile, e);
        }
        catch (IllegalArgumentException e) {
            throw this.createApplyFormatException(basePathName, layoutFileName, layoutFile, e);
        }
        return new BulkValidator(formatter, this.partInfo.getFileName());
    }

    private IllegalStateException createApplyFormatException(String basePathName, String layoutFileName, File layoutFile, Throwable e) {
        return new IllegalStateException(Builder.concat((Object[])new Object[]{"fail applying format file. basePathName=[", basePathName, "] ", "layoutFileName=[", layoutFileName, "] ", "layoutFile=[", layoutFile.getAbsolutePath(), "]", "partInfo=[", this.partInfo, "]"}), e);
    }

    private File getLayoutFile(String basePathName, String layoutFileName) {
        File layoutFile = FilePathSetting.getInstance().getFileWithoutCreate(basePathName, layoutFileName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(Builder.concat((Object[])new Object[]{"applying format file. basePathName=[", basePathName, "] ", "layoutFileName=[", layoutFileName, "] ", "layoutFile=[", layoutFile.getAbsolutePath(), "]"}), new Object[0]);
        }
        return layoutFile;
    }

    @Published
    public byte[] toByteArray() {
        return BinaryUtil.toByteArray(this.partInfo.getInputStream());
    }

    private void logContentOfUploaded() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(Builder.concat((Object[])new Object[]{"content of uploaded file is [", BinaryUtil.convertToHexStringWithPrefix(this.toByteArray()), "]"}), new Object[0]);
        }
    }
}

