/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.csrf;

import nablarch.common.web.WebConfig;
import nablarch.common.web.WebConfigFinder;
import nablarch.common.web.session.SessionUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;

@Published(tag={"architect"})
public final class CsrfTokenUtil {
    private CsrfTokenUtil() {
    }

    public static String getCsrfToken(ExecutionContext context) {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        return (String)SessionUtil.orNull(context, webConfig.getCsrfTokenSessionStoredVarName());
    }

    public static String getHeaderName() {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        return webConfig.getCsrfTokenHeaderName();
    }

    public static String getParameterName() {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        return webConfig.getCsrfTokenParameterName();
    }

    public static void regenerateCsrfToken(ExecutionContext context) {
        context.setRequestScopedVar("nablarch_request_for_csrf_token_to_be_regenerated", (Object)Boolean.TRUE);
    }
}

