/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import javax.servlet.http.Cookie;
import nablarch.core.util.StringUtil;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class CookieSupport {
    private String cookieName = "nablarch_language";
    private String cookiePath = null;
    private String cookieDomain = null;
    private Integer cookieMaxAge = null;
    private boolean secure = false;
    private boolean httpOnly = true;

    public CookieSupport(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void setCookieSecure(boolean secure) {
        this.secure = secure;
    }

    public void setCookieHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public Cookie createCookie(ServletExecutionContext ctx, String value) {
        HttpCookie httpCookie = new HttpCookie();
        httpCookie.put(this.cookieName, value);
        if (this.cookiePath != null) {
            httpCookie.setPath(this.cookiePath);
        } else {
            String contextPath = ctx.getServletRequest().getContextPath();
            if (StringUtil.isNullOrEmpty((String)contextPath)) {
                contextPath = "/";
            }
            httpCookie.setPath(contextPath);
        }
        if (this.cookieDomain != null) {
            httpCookie.setDomain(this.cookieDomain);
        }
        if (this.cookieMaxAge != null) {
            httpCookie.setMaxAge(this.cookieMaxAge);
        }
        httpCookie.setSecure(this.secure);
        if (httpCookie.supportsHttpOnly()) {
            httpCookie.setHttpOnly(this.httpOnly);
        }
        return httpCookie.convertServletCookies().get(0);
    }

    public String getCookieValue(ServletExecutionContext ctx) {
        Cookie[] cookies = ctx.getServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

