/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import nablarch.common.handler.threadcontext.LanguageAttribute;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Request;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpLanguageAttribute
extends LanguageAttribute {
    private Set<String> supportedLanguages;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    public void setSupportedLanguages(String ... supportedLanguages) {
        this.supportedLanguages = new HashSet<String>(Arrays.asList(supportedLanguages));
    }

    public Object getValue(Request<?> req, ExecutionContext ctx) {
        return this.getLocale((HttpRequest)req, (ServletExecutionContext)ctx);
    }

    protected Locale getLocale(HttpRequest req, ServletExecutionContext ctx) {
        String acceptLanguage = this.getAcceptLanguage(req, ctx);
        if (acceptLanguage != null) {
            return new Locale(acceptLanguage);
        }
        return (Locale)super.getValue((Request)req, (ExecutionContext)ctx);
    }

    protected String getAcceptLanguage(HttpRequest req, ServletExecutionContext ctx) {
        String acceptLanguages = ctx.getServletRequest().getHeader("Accept-Language");
        if (StringUtil.isNullOrEmpty((String)acceptLanguages)) {
            return null;
        }
        String language = null;
        double qualityValue = -1.0;
        for (String acceptLanguage : COMMA_PATTERN.split(acceptLanguages)) {
            double candidateQualityValue;
            int languageRangeIndex = acceptLanguage.indexOf(";q=");
            String candidateLanguage = languageRangeIndex == -1 ? acceptLanguage : acceptLanguage.substring(0, languageRangeIndex);
            int subTagIndex = (candidateLanguage = candidateLanguage.trim()).indexOf("-");
            if (subTagIndex != -1) {
                candidateLanguage = candidateLanguage.substring(0, subTagIndex);
            }
            if (!this.isSupportedLanguage(candidateLanguage)) continue;
            if (languageRangeIndex == -1) {
                candidateQualityValue = 1.0;
            } else {
                try {
                    candidateQualityValue = Double.parseDouble(acceptLanguage.substring(languageRangeIndex + 3).trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (candidateQualityValue == 1.0) {
                return candidateLanguage;
            }
            if (!(qualityValue < candidateQualityValue)) continue;
            language = candidateLanguage;
            qualityValue = candidateQualityValue;
        }
        return language != null ? language : null;
    }

    protected boolean isSupportedLanguage(String language) {
        return this.supportedLanguages.contains(language);
    }
}

