/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import java.util.Locale;
import nablarch.common.web.handler.threadcontext.LanguageAttributeInHttpSupport;
import nablarch.core.ThreadContext;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public final class LanguageAttributeInHttpUtil {
    private static final String LANGUAGE_ATTRIBUTE_COMPONENT_NAME = "languageAttribute";

    private LanguageAttributeInHttpUtil() {
    }

    public static void keepLanguage(HttpRequest request, ExecutionContext context, String language) {
        LanguageAttributeInHttpSupport support = (LanguageAttributeInHttpSupport)((Object)SystemRepository.get((String)LANGUAGE_ATTRIBUTE_COMPONENT_NAME));
        if (support == null) {
            throw new RuntimeException("component languageAttribute was not found.");
        }
        if (!support.isSupportedLanguage(language)) {
            return;
        }
        support.keepLanguage(request, (ServletExecutionContext)context, language);
        ThreadContext.setLanguage((Locale)new Locale(language));
    }
}

