/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import javax.servlet.http.Cookie;
import nablarch.common.web.handler.threadcontext.CookieSupport;
import nablarch.common.web.handler.threadcontext.TimeZoneAttributeInHttpSupport;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public class TimeZoneAttributeInHttpCookie
extends TimeZoneAttributeInHttpSupport {
    private final CookieSupport cookieSupport = new CookieSupport("nablarch_timeZone");

    public void setCookieName(String cookieName) {
        this.cookieSupport.setCookieName(cookieName);
    }

    public void setCookiePath(String cookiePath) {
        this.cookieSupport.setCookiePath(cookiePath);
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieSupport.setCookieDomain(cookieDomain);
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieSupport.setCookieMaxAge(cookieMaxAge);
    }

    public void setCookieSecure(boolean secure) {
        this.cookieSupport.setCookieSecure(secure);
    }

    public void setCookieHttpOnly(boolean httpOnly) {
        this.cookieSupport.setCookieHttpOnly(httpOnly);
    }

    @Override
    protected void keepTimeZone(HttpRequest req, ServletExecutionContext ctx, String timeZone) {
        Cookie cookie = this.cookieSupport.createCookie(ctx, timeZone);
        ctx.getServletResponse().addCookie(cookie);
    }

    @Override
    protected String getKeepingTimeZone(HttpRequest req, ServletExecutionContext ctx) {
        return this.cookieSupport.getCookieValue(ctx);
    }
}

