/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import nablarch.common.handler.threadcontext.TimeZoneAttribute;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Request;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public abstract class TimeZoneAttributeInHttpSupport
extends TimeZoneAttribute {
    private Set<String> supportedTimeZones;

    public void setSupportedTimeZones(String ... supportedTimeZones) {
        this.supportedTimeZones = new HashSet<String>(Arrays.asList(supportedTimeZones));
    }

    protected boolean isSupportedTimeZone(String timeZone) {
        return this.supportedTimeZones.contains(timeZone);
    }

    public Object getValue(Request<?> req, ExecutionContext ctx) {
        return this.getTimeZone((HttpRequest)req, (ServletExecutionContext)ctx);
    }

    protected TimeZone getTimeZone(HttpRequest req, ServletExecutionContext ctx) {
        String keepingTimeZone = this.getKeepingTimeZone(req, ctx);
        if (this.isSupportedTimeZone(keepingTimeZone)) {
            return TimeZone.getTimeZone(keepingTimeZone);
        }
        return (TimeZone)super.getValue((Request)req, (ExecutionContext)ctx);
    }

    protected abstract void keepTimeZone(HttpRequest var1, ServletExecutionContext var2, String var3);

    protected abstract String getKeepingTimeZone(HttpRequest var1, ServletExecutionContext var2);
}

