/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.interceptor;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.common.web.validator.NablarchValidationStrategy;
import nablarch.common.web.validator.ValidationStrategy;
import nablarch.core.beans.BeanUtil;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Interceptor;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Documented
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Interceptor(value=Impl.class)
@Published
public @interface InjectForm {
    public Class<? extends Serializable> form();

    public String prefix() default "";

    public String name() default "form";

    public String initialize() default "";

    public String validate() default "";

    public static class Impl
    extends Interceptor.Impl<HttpRequest, HttpResponse, InjectForm> {
        private ValidationStrategy validationStrategy = Impl.getValidationStrategy();

        public HttpResponse handle(HttpRequest request, ExecutionContext context) {
            InjectForm annotation = (InjectForm)this.getInterceptor();
            boolean canInitialize = StringUtil.hasValue((String)annotation.initialize());
            boolean canValidate = StringUtil.hasValue((String)annotation.validate());
            Serializable form = this.validationStrategy.validate(request, annotation, canValidate, (ServletExecutionContext)context);
            if (canInitialize) {
                Serializable initForm = this.createForm(annotation);
                this.initializeForm(request, context, annotation, initForm);
                Serializable serializable = form = form != null ? (Serializable)BeanUtil.copyExcludesNull((Object)form, (Object)initForm) : initForm;
            }
            if (form == null) {
                form = this.createForm(annotation);
            }
            context.setRequestScopedVar(annotation.name(), (Object)form);
            return (HttpResponse)this.getOriginalHandler().handle((Object)request, context);
        }

        private Serializable createForm(InjectForm annotation) {
            return this.newInstance(annotation.form());
        }

        private <T> T newInstance(Class<T> c) {
            try {
                return c.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("class instantiation failed. class = [" + c.getName() + "]", e);
            }
        }

        private void initializeForm(HttpRequest request, ExecutionContext context, InjectForm annotation, Serializable form) {
            try {
                annotation.form().getMethod(annotation.initialize(), HttpRequest.class, ExecutionContext.class).invoke((Object)form, request, context);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("form initialization failed. form = [" + annotation.form().getName() + "], method = [" + annotation.initialize() + "]", e);
            }
        }

        private static synchronized ValidationStrategy getValidationStrategy() {
            ValidationStrategy validationStrategy = (ValidationStrategy)SystemRepository.get((String)"validationStrategy");
            if (validationStrategy == null) {
                validationStrategy = new NablarchValidationStrategy();
            }
            return validationStrategy;
        }
    }
}

