/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import nablarch.common.web.session.Expiration;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpSessionManagedExpiration
implements Expiration {
    private static final String EXPIRATION_DATE_KEY = "nablarch_sessionStore_expiration_date";

    @Override
    public boolean isExpired(String sessionId, long currentDateTime, ExecutionContext context) {
        Long expiration = (Long)context.getSessionScopedVar(EXPIRATION_DATE_KEY);
        if (expiration == null) {
            return true;
        }
        return expiration < currentDateTime;
    }

    @Override
    public void saveExpirationDateTime(String sessionId, long expirationDateTime, ExecutionContext context) {
        context.setSessionScopedVar(EXPIRATION_DATE_KEY, (Object)expirationDateTime);
    }

    @Override
    public boolean isDeterminable(String sessionId, ExecutionContext context) {
        return ((ServletExecutionContext)context).getNativeHttpSession(false) != null;
    }
}

