/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionManager;
import nablarch.common.web.session.SessionStore;
import nablarch.fw.ExecutionContext;

public class Session
implements Serializable,
Iterable<SessionEntry> {
    private static final long serialVersionUID = 1L;
    private String sessionId;
    private transient SessionManager factory;
    private final transient ExecutionContext executionContext;
    private final transient Map<String, SessionEntry> entryMap = new HashMap<String, SessionEntry>();

    public Session(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void invalidate() {
        if (this.sessionId != null) {
            for (SessionStore store : this.factory.getAvailableStores()) {
                store.invalidate(this.sessionId, this.executionContext);
            }
            this.sessionId = null;
        }
    }

    public String getOrGenerateId() {
        if (this.sessionId == null) {
            this.sessionId = UUID.randomUUID().toString();
        }
        return this.sessionId;
    }

    public String getId() {
        return this.sessionId;
    }

    public void load(String sessionId) {
        this.sessionId = sessionId;
        for (SessionStore store : this.factory.getAvailableStores()) {
            List<SessionEntry> entries = store.load(sessionId, this.executionContext);
            for (SessionEntry entry : entries) {
                this.entryMap.put(entry.getKey(), entry);
            }
        }
    }

    public void save() {
        if (this.sessionId == null) {
            this.getOrGenerateId();
        }
        HashMap<SessionStore, ArrayList<SessionEntry>> entriesByStorage = new HashMap<SessionStore, ArrayList<SessionEntry>>();
        for (SessionEntry entry : this.entryMap.values()) {
            ArrayList<SessionEntry> entries = (ArrayList<SessionEntry>)entriesByStorage.get(entry.getStorage());
            if (entries == null) {
                entries = new ArrayList<SessionEntry>();
                entriesByStorage.put(entry.getStorage(), entries);
            }
            entries.add(entry);
        }
        ArrayList<SessionStore> stores = new ArrayList<SessionStore>(this.factory.getAvailableStores());
        for (Map.Entry e : entriesByStorage.entrySet()) {
            ((SessionStore)e.getKey()).save(this.sessionId, (List)e.getValue(), this.executionContext);
            stores.remove(e.getKey());
        }
        for (SessionStore store : stores) {
            store.delete(this.sessionId, this.executionContext);
        }
    }

    public Object get(String key) {
        SessionEntry entry = this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public <T> T get(String key, Class<T> type) {
        Object value = this.get(key);
        return type.cast(value);
    }

    public void put(String key, Object value, String storeName) {
        for (SessionStore storage : this.factory.getAvailableStores()) {
            if (!storage.getName().equals(storeName)) continue;
            this.entryMap.put(key, new SessionEntry(key, value, storage));
            return;
        }
    }

    public void put(SessionEntry entry) {
        this.entryMap.put(entry.getKey(), entry);
    }

    public void delete(String key) {
        this.entryMap.remove(key);
    }

    public void deleteAll() {
        this.entryMap.clear();
    }

    protected void setSessionFactory(SessionManager factory) {
        this.factory = factory;
    }

    public SessionManager getSessionFactory() {
        return this.factory;
    }

    @Override
    public Iterator<SessionEntry> iterator() {
        return this.entryMap.values().iterator();
    }
}

