/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nablarch.common.web.session.SessionStore;
import nablarch.core.beans.BeanUtil;
import nablarch.core.beans.BeansException;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class SessionEntry
implements Map<String, Object> {
    private final String key;
    private final Object value;
    private final SessionStore storage;
    private Map<String, Object> valueObjectMap;

    public SessionEntry(String key, Object value, SessionStore storage) {
        this.key = key;
        this.value = value;
        this.storage = storage;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public SessionStore getStorage() {
        return this.storage;
    }

    private void introspectValue() {
        if (this.valueObjectMap != null) {
            return;
        }
        if (this.value == null) {
            this.valueObjectMap = Collections.emptyMap();
            return;
        }
        try {
            PropertyDescriptor[] pds = BeanUtil.getPropertyDescriptors(this.value.getClass());
            this.valueObjectMap = new HashMap<String, Object>(pds.length);
            for (PropertyDescriptor pd : pds) {
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                this.valueObjectMap.put(pd.getName(), getter.invoke(this.value, new Object[0]));
            }
        }
        catch (IllegalAccessException ignored) {
            this.valueObjectMap = Collections.emptyMap();
        }
        catch (InvocationTargetException ignored) {
            this.valueObjectMap = Collections.emptyMap();
        }
        catch (BeansException ignored) {
            this.valueObjectMap = Collections.emptyMap();
        }
    }

    @Override
    public int size() {
        this.introspectValue();
        return this.valueObjectMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.introspectValue();
        return this.valueObjectMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.introspectValue();
        return this.valueObjectMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.introspectValue();
        return this.valueObjectMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        this.introspectValue();
        return this.valueObjectMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("This object is immutable.");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("This object is immutable.");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("This object is immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This object is immutable.");
    }

    @Override
    public Set<String> keySet() {
        this.introspectValue();
        return this.valueObjectMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.introspectValue();
        return this.valueObjectMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.introspectValue();
        return this.valueObjectMap.entrySet();
    }
}

