/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.common.web.session.Session;
import nablarch.common.web.session.SessionStore;
import nablarch.common.web.session.StateEncoder;
import nablarch.common.web.session.encoder.JavaSerializeStateEncoder;
import nablarch.fw.ExecutionContext;

public class SessionManager {
    private String defaultStoreName;
    private Map<String, SessionStore> availableStores;
    private List<SessionStore> orderedStores;
    private StateEncoder defaultEncoder = new JavaSerializeStateEncoder();

    public Session create(ExecutionContext executionContext) {
        Session session = new Session(executionContext);
        session.setSessionFactory(this);
        return session;
    }

    public void setDefaultStoreName(String defaultStoreName) {
        this.defaultStoreName = defaultStoreName;
    }

    public void setAvailableStores(List<SessionStore> sessionStores) {
        if (sessionStores == null || sessionStores.isEmpty()) {
            throw new IllegalArgumentException("availableStores must not be empty.");
        }
        this.availableStores = new HashMap<String, SessionStore>();
        for (SessionStore store : sessionStores) {
            this.availableStores.put(store.getName(), store);
            if (store.getStateEncoder() != null) continue;
            store.setStateEncoder(this.defaultEncoder);
        }
        this.availableStores = Collections.unmodifiableMap(this.availableStores);
        this.orderedStores = Collections.unmodifiableList(sessionStores);
    }

    public List<SessionStore> getAvailableStores() {
        if (this.availableStores == null) {
            throw new IllegalStateException("must be set availableStores property.");
        }
        return this.orderedStores;
    }

    public SessionStore findSessionStore(String storeName) {
        if (!this.availableStores.containsKey(storeName)) {
            throw new IllegalStateException("not found session store. storeName=[" + storeName + "]");
        }
        return this.availableStores.get(storeName);
    }

    public SessionStore getDefaultStore() {
        if (this.defaultStoreName == null) {
            throw new IllegalStateException("must be set defaultStoreName property.");
        }
        return this.findSessionStore(this.defaultStoreName);
    }

    public StateEncoder getDefaultEncoder() {
        return this.defaultEncoder;
    }

    public void setDefaultEncoder(StateEncoder defaultEncoder) {
        this.defaultEncoder = defaultEncoder;
    }
}

