/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import nablarch.common.web.session.EncodeException;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.StateEncoder;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;

@Published(tag={"architect"})
public abstract class SessionStore {
    private String name;
    private Long expiresMilliSeconds;
    private StateEncoder stateEncoder;

    protected SessionStore(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExpires(Long expires) {
        this.setExpires(expires, TimeUnit.SECONDS);
    }

    public void setExpires(Long expires, TimeUnit timeUnit) {
        this.expiresMilliSeconds = timeUnit.toMillis(expires);
    }

    public abstract List<SessionEntry> load(String var1, ExecutionContext var2);

    public abstract void save(String var1, List<SessionEntry> var2, ExecutionContext var3);

    public abstract void delete(String var1, ExecutionContext var2);

    public abstract void invalidate(String var1, ExecutionContext var2);

    protected byte[] encode(List<SessionEntry> entries) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            for (SessionEntry entry : entries) {
                dos.writeUTF(entry.getKey());
                Object obj = entry.getValue();
                if (obj == null) {
                    dos.writeInt(0);
                    continue;
                }
                byte[] encoded = this.stateEncoder.encode(obj);
                dos.writeInt(encoded.length);
                dos.writeUTF(obj.getClass().getName());
                dos.write(encoded);
            }
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        return baos.toByteArray();
    }

    protected List<SessionEntry> decode(byte[] encoded) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(encoded));
        ArrayList<SessionEntry> entries = new ArrayList<SessionEntry>();
        try {
            while (dis.available() > 0) {
                String key = dis.readUTF();
                int length = dis.readInt();
                if (length == 0) {
                    entries.add(new SessionEntry(key, null, this));
                    continue;
                }
                String typeName = dis.readUTF();
                byte[] buf = new byte[length];
                dis.read(buf);
                Class<?> type = Class.forName(typeName);
                entries.add(new SessionEntry(key, this.stateEncoder.decode(buf, type), this));
            }
            return entries;
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new EncodeException(e);
        }
    }

    public long getExpiresMilliSeconds() {
        return this.expiresMilliSeconds;
    }

    public boolean isExtendable() {
        return true;
    }

    public StateEncoder getStateEncoder() {
        return this.stateEncoder;
    }

    public void setStateEncoder(StateEncoder stateEncoder) {
        this.stateEncoder = stateEncoder;
    }
}

